/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.AFM;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.fonts.ofont.CMap;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;
import org.icepdf.core.pobjects.fonts.ofont.OFont;
import org.icepdf.core.util.FontUtil;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
extends org.icepdf.core.pobjects.fonts.Font {
    private static final Logger logger = Logger.getLogger(Font.class.toString());
    private Encoding encoding;
    private String encodingName;
    private Vector widths;
    private Map<Integer, Float> cidWidths;
    private char[] cMap = new char[256];
    private CMap toUnicodeCMap;
    protected AFM afm;
    protected int style;
    private static final java.awt.Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    static final String[][] type1Diff = new String[][]{{"Bookman-Demi", "URWBookmanL-DemiBold", "Arial"}, {"Bookman-DemiItalic", "URWBookmanL-DemiBoldItal", "Arial"}, {"Bookman-Light", "URWBookmanL-Ligh", "Arial"}, {"Bookman-LightItalic", "URWBookmanL-LighItal", "Arial"}, {"Courier", "Nimbus Mono L Regular", "Nimbus Mono L"}, {"Courier-Oblique", "Nimbus Mono L Regular Oblique", "Nimbus Mono L"}, {"Courier-Bold", "Nimbus Mono L Bold", "Nimbus Mono L"}, {"Courier-BoldOblique", "Nimbus Mono L Bold Oblique", "Nimbus Mono L"}, {"AvantGarde-Book", "URWGothicL-Book", "Arial"}, {"AvantGarde-BookOblique", "URWGothicL-BookObli", "Arial"}, {"AvantGarde-Demi", "URWGothicL-Demi", "Arial"}, {"AvantGarde-DemiOblique", "URWGothicL-DemiObli", "Arial"}, {"Helvetica", "Nimbus Sans L Regular", "Nimbus Sans L"}, {"Helvetica-Oblique", "Nimbus Sans L Regular Italic", "Nimbus Sans L"}, {"Helvetica-Bold", "Nimbus Sans L Bold", "Nimbus Sans L"}, {"Helvetica-BoldOblique", "Nimbus Sans L Bold Italic", "Nimbus Sans L"}, {"Helvetica-Narrow", "Nimbus Sans L Regular Condensed", "Nimbus Sans L"}, {"Helvetica-Narrow-Oblique", "Nimbus Sans L Regular Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Narrow-Bold", "Nimbus Sans L Bold Condensed", "Nimbus Sans L"}, {"Helvetica-Narrow-BoldOblique", "Nimbus Sans L Bold Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Condensed", "Nimbus Sans L Regular Condensed", "Nimbus Sans L"}, {"Helvetica-Condensed-Oblique", "Nimbus Sans L Regular Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Condensed-Bold", "Nimbus Sans L Bold Condensed", "Nimbus Sans L"}, {"Helvetica-Condensed-BoldOblique", "Nimbus Sans L Bold Condensed Italic", "Nimbus Sans L"}, {"Palatino-Roman", "URWPalladioL-Roma", "Arial"}, {"Palatino-Italic", "URWPalladioL-Ital", "Arial"}, {"Palatino-Bold", "URWPalladioL-Bold", "Arial"}, {"Palatino-BoldItalic", "URWPalladioL-BoldItal", "Arial"}, {"NewCenturySchlbk-Roman", "CenturySchL-Roma", "Arial"}, {"NewCenturySchlbk-Italic", "CenturySchL-Ital", "Arial"}, {"NewCenturySchlbk-Bold", "CenturySchL-Bold", "Arial"}, {"NewCenturySchlbk-BoldItalic", "CenturySchL-BoldItal", "Arial"}, {"Times-Roman", "Nimbus Roman No9 L Regular", "Nimbus Roman No9 L"}, {"Times-Italic", "Nimbus Roman No9 L Regular Italic", "Nimbus Roman No9 L"}, {"Times-Bold", "Nimbus Roman No9 L Medium", "Nimbus Roman No9 L"}, {"Times-BoldItalic", "Nimbus Roman No9 L Medium Italic", "Nimbus Roman No9 L"}, {"Symbol", "Standard Symbols L", "Standard Symbols L"}, {"ZapfChancery-MediumItalic", "URWChanceryL-MediItal", "Arial"}, {"ZapfDingbats", "Dingbats", "Dingbats"}};

    public Font(Library library, Hashtable hashtable) {
        super(library, hashtable);
        for (int n = 0; n < 256; n = (int)((char)(n + 1))) {
            this.cMap[n] = n;
        }
        this.style = FontUtil.guessAWTFontStyle(this.basefont);
        this.basefont = this.cleanFontName(this.basefont);
        if (this.subtype.equals("Type3")) {
            this.basefont = "Symbol";
            this.encoding = Encoding.getSymbol();
        }
        if (this.subtype.equals("Type1")) {
            if (this.basefont.equals("Symbol")) {
                this.encoding = Encoding.getSymbol();
            } else if (this.basefont.equalsIgnoreCase("ZapfDingbats") && this.subtype.equals("Type1")) {
                this.encoding = Encoding.getZapfDingBats();
            } else {
                for (String[] stringArray : type1Diff) {
                    if (!this.basefont.equals(stringArray[0])) continue;
                    this.encodingName = "standard";
                    this.encoding = Encoding.getStandard();
                    break;
                }
            }
        }
        if (this.subtype.equals("TrueType") && this.basefont.equals("Symbol")) {
            this.encodingName = "winAnsi";
            this.encoding = Encoding.getWinAnsi();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void init() {
        AFM aFM;
        Vector vector;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (this.inited) {
            return;
        }
        if (this.encoding != null) {
            for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
                this.cMap[c] = this.encoding.get(c);
            }
        }
        if ((object6 = this.library.getObject(this.entries, "ToUnicode")) != null && object6 instanceof Stream) {
            this.toUnicodeCMap = new CMap(this.library, new Hashtable(), (Stream)object6);
            this.toUnicodeCMap.init();
        }
        if ((object5 = this.library.getObject(this.entries, "Encoding")) != null) {
            if (object5 instanceof Hashtable) {
                object4 = (Hashtable)object5;
                this.setBaseEncoding(this.library.getName((Hashtable)object4, "BaseEncoding"));
                object3 = (Vector)this.library.getObject((Hashtable)object4, "Differences");
                if (object3 != null) {
                    int n = 0;
                    object2 = ((Vector)object3).elements();
                    while (object2.hasMoreElements()) {
                        object = object2.nextElement();
                        if (object instanceof Number) {
                            n = ((Number)object).intValue();
                            continue;
                        }
                        if (!(object instanceof Name)) continue;
                        String string = object.toString();
                        int n2 = Encoding.getUV(string);
                        if (n2 == -1 && string.charAt(0) == 'a') {
                            String string2 = string.substring(1);
                            try {
                                n2 = Integer.parseInt(string2);
                            }
                            catch (Exception exception) {
                                logger.log(Level.FINE, "Error parings font differences");
                            }
                        }
                        this.cMap[n] = (char)n2;
                        ++n;
                    }
                }
            } else if (object5 instanceof Name) {
                this.setBaseEncoding(((Name)object5).getName());
            }
        }
        this.widths = (Vector)this.library.getObject(this.entries, "Widths");
        if (this.widths != null) {
            object5 = this.library.getObject(this.entries, "FirstChar");
            if (object5 != null) {
                this.firstchar = (int)this.library.getFloat(this.entries, "FirstChar");
            }
        } else if (this.library.getObject(this.entries, "W") != null) {
            this.cidWidths = this.calculateCIDWidths();
            this.firstchar = 0;
            this.isAFMFont = false;
        } else {
            this.isAFMFont = false;
        }
        if ((object4 = this.library.getObject(this.entries, "FontDescriptor")) instanceof FontDescriptor) {
            this.fontDescriptor = (FontDescriptor)object4;
            this.fontDescriptor.init();
        }
        if (this.fontDescriptor == null && this.basefont != null && (object3 = AFM.AFMs.get(this.basefont.toLowerCase())) != null && object3 instanceof AFM) {
            AFM aFM2 = (AFM)object3;
            this.fontDescriptor = FontDescriptor.createDescriptor(this.library, aFM2);
            this.fontDescriptor.init();
        }
        if (this.fontDescriptor != null && this.fontDescriptor.getFontName().length() > 0) {
            this.basefont = this.fontDescriptor.getFontName();
            this.basefont = this.cleanFontName(this.basefont);
        }
        if (this.fontDescriptor != null && (this.fontDescriptor.getFlags() & 0x40) != 0 && this.encoding == null) {
            this.encodingName = "standard";
            this.encoding = Encoding.getStandard();
        }
        if ((object3 = this.library.getObject(this.entries, "DescendantFonts")) != null && (vector = (Vector)object3).elementAt(0) instanceof Reference && (object2 = this.library.getObject((Reference)vector.elementAt(0))) instanceof Font) {
            object = (Font)object2;
            ((Font)object).toUnicodeCMap = this.toUnicodeCMap;
            ((Font)object).init();
            this.cidWidths = ((Font)object).cidWidths;
            if (this.fontDescriptor == null) {
                this.fontDescriptor = ((Font)object).fontDescriptor;
                this.basefont = this.fontDescriptor.getFontName();
                this.basefont = this.cleanFontName(this.basefont);
            }
        }
        if (this.subtype.equals("Type1") && (aFM = AFM.AFMs.get(this.basefont.toLowerCase())) != null && aFM.getFontName() != null) {
            this.afm = aFM;
        }
        if (this.subtype.equals("Type1")) {
            for (String[] stringArray : type1Diff) {
                java.awt.Font font;
                if (!this.basefont.equals(stringArray[0]) || !(font = new java.awt.Font(stringArray[1], 0, 12)).getFamily().equals(stringArray[2])) continue;
                this.basefont = stringArray[1];
                break;
            }
        }
        this.isFontSubstitution = true;
        if (this.fontDescriptor != null && this.fontDescriptor.getEmbeddedFont() != null) {
            this.font = this.fontDescriptor.getEmbeddedFont();
            this.isFontSubstitution = false;
            this.isAFMFont = false;
        }
        if (this.font == null && this.basefont != null) {
            for (java.awt.Font font : fonts) {
                StringTokenizer stringTokenizer = new StringTokenizer(font.getPSName(), " ", false);
                String string = "";
                while (stringTokenizer.hasMoreElements()) {
                    string = string + stringTokenizer.nextElement();
                }
                if (!string.equalsIgnoreCase(this.basefont)) continue;
                this.font = new OFont(new java.awt.Font(font.getFamily(), this.style, 1));
                this.basefont = font.getPSName();
                this.isFontSubstitution = true;
                break;
            }
        }
        if (this.font == null && this.basefont != null) {
            void var8_29;
            String string = FontUtil.guessFamily(this.basefont);
            java.awt.Font[] fontArray = fonts;
            int n = fontArray.length;
            boolean bl = false;
            while (var8_29 < n) {
                java.awt.Font font = fontArray[var8_29];
                if (font.getFamily().equalsIgnoreCase(string)) {
                    this.font = new OFont(new java.awt.Font(font.getFamily(), this.style, 1));
                    this.isFontSubstitution = true;
                    break;
                }
                ++var8_29;
            }
        }
        if (this.font == null && this.basefont != null && this.basefont.indexOf("-") != -1) {
            this.font = new OFont(java.awt.Font.decode(this.basefont));
            this.basefont = this.font.getName();
        }
        if (this.font == null) {
            this.font = new OFont(java.awt.Font.getFont(this.basefont, new java.awt.Font(this.basefont, 0, 12)));
            this.basefont = this.font.getName();
        }
        if (!this.isFontSubstitution && this.font.getName().toLowerCase().indexOf(this.font.getFamily().toLowerCase()) < 0) {
            if (this.font.getName().toLowerCase().indexOf("times new roman") != -1 || this.font.getName().toLowerCase().indexOf("timesnewroman") != -1 || this.font.getName().toLowerCase().indexOf("bodoni") != -1 || this.font.getName().toLowerCase().indexOf("garamond") != -1 || this.font.getName().toLowerCase().indexOf("minion web") != -1 || this.font.getName().toLowerCase().indexOf("stone serif") != -1 || this.font.getName().toLowerCase().indexOf("stoneserif") != -1 || this.font.getName().toLowerCase().indexOf("georgia") != -1 || this.font.getName().toLowerCase().indexOf("bitstream cyberbit") != -1) {
                this.font = new OFont(new java.awt.Font("serif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "serif";
            } else if (this.font.getName().toLowerCase().indexOf("helvetica") != -1 || this.font.getName().toLowerCase().indexOf("arial") != -1 || this.font.getName().toLowerCase().indexOf("trebuchet") != -1 || this.font.getName().toLowerCase().indexOf("avant garde gothic") != -1 || this.font.getName().toLowerCase().indexOf("avantgardegothic") != -1 || this.font.getName().toLowerCase().indexOf("verdana") != -1 || this.font.getName().toLowerCase().indexOf("univers") != -1 || this.font.getName().toLowerCase().indexOf("futura") != -1 || this.font.getName().toLowerCase().indexOf("stone sans") != -1 || this.font.getName().toLowerCase().indexOf("stonesans") != -1 || this.font.getName().toLowerCase().indexOf("gill sans") != -1 || this.font.getName().toLowerCase().indexOf("gillsans") != -1 || this.font.getName().toLowerCase().indexOf("akzidenz") != -1 || this.font.getName().toLowerCase().indexOf("grotesk") != -1) {
                this.font = new OFont(new java.awt.Font("sansserif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "sansserif";
            } else if (this.font.getName().toLowerCase().indexOf("courier") != -1 || this.font.getName().toLowerCase().indexOf("courier new") != -1 || this.font.getName().toLowerCase().indexOf("couriernew") != -1 || this.font.getName().toLowerCase().indexOf("prestige") != -1 || this.font.getName().toLowerCase().indexOf("eversonmono") != -1 || this.font.getName().toLowerCase().indexOf("Everson Mono") != -1) {
                this.font = new OFont(new java.awt.Font("monospaced", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "monospaced";
            } else {
                this.font = new OFont(new java.awt.Font("serif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "serif";
            }
        }
        this.setWidth();
        this.font = this.font.deriveFont(this.encoding, this.toUnicodeCMap);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.name + " - " + this.encodingName + " " + this.basefont + " " + this.font.toString() + " " + this.isFontSubstitution);
        }
        this.inited = true;
    }

    private void setBaseEncoding(String string) {
        if (string == null) {
            this.encodingName = "none";
            return;
        }
        if (string.equals("StandardEncoding")) {
            this.encodingName = "StandardEncoding";
            this.encoding = Encoding.getStandard();
        } else if (string.equals("MacRomanEncoding")) {
            this.encodingName = "MacRomanEncoding";
            this.encoding = Encoding.getMacRoman();
        } else if (string.equals("WinAnsiEncoding")) {
            this.encodingName = "WinAnsiEncoding";
            this.encoding = Encoding.getWinAnsi();
        } else if (string.equals("PDFDocEncoding")) {
            this.encodingName = "PDFDocEncoding";
            this.encoding = Encoding.getPDFDoc();
        }
        if (this.encoding != null) {
            for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
                this.cMap[c] = this.encoding.get(c);
            }
        }
    }

    @Override
    public String toString() {
        return "FONT= " + this.encodingName + " " + this.entries.toString();
    }

    private float getWidth(int n, float f) {
        n -= this.firstchar;
        if (this.widths != null) {
            if (n >= 0 && n < this.widths.size()) {
                return ((Number)this.widths.elementAt(n)).floatValue() / 1000.0f;
            }
        } else if (this.afm != null) {
            Float f2 = Float.valueOf(this.afm.getWidths()[n]);
            if (f2 != null) {
                return f2.floatValue() / 1000.0f;
            }
        } else if (this.fontDescriptor != null && this.fontDescriptor.getMissingWidth() > 0.0f) {
            return this.fontDescriptor.getMissingWidth() / 1000.0f;
        }
        return f;
    }

    private void setWidth() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.fontDescriptor != null && this.fontDescriptor.getMissingWidth() > 0.0f) {
            f = this.fontDescriptor.getMissingWidth() / 1000.0f;
            f2 = this.fontDescriptor.getAscent() / 1000.0f;
            f3 = this.fontDescriptor.getDescent() / 1000.0f;
        }
        if (this.widths != null) {
            float[] fArray = new float[256 - this.firstchar];
            int n = this.widths.size();
            for (int i = 0; i < n; ++i) {
                if (this.widths.elementAt(i) == null) continue;
                fArray[i] = ((Number)this.widths.elementAt(i)).floatValue() / 1000.0f;
            }
            this.font = this.font.deriveFont(fArray, this.firstchar, f, f2, f3, this.cMap);
        } else if (this.cidWidths != null) {
            this.font = this.font.deriveFont(this.cidWidths, this.firstchar, f, f2, f3, null);
        } else if (this.afm != null) {
            this.font = this.font.deriveFont(this.afm.getWidths(), this.firstchar, f, f2, f3, this.cMap);
        }
    }

    private String cleanFontName(String string) {
        int n;
        block5: {
            if (string.indexOf(43) >= 0) {
                n = string.indexOf(43);
                String string2 = string.substring(n + 1);
                try {
                    Integer.parseInt(string2);
                    string = string.substring(0, n);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.fine("error cleaning font base name " + string);
                }
            }
        }
        while (string.indexOf(43) >= 0) {
            n = string.indexOf(43);
            string = string.substring(n + 1, string.length());
        }
        if ((this.subtype.equals("Type0") || this.subtype.equals("Type1") || this.subtype.equals("MMType1") || this.subtype.equals("TrueType")) && string != null) {
            string = string.replace(',', '-');
        }
        return string;
    }

    private Map<Integer, Float> calculateCIDWidths() {
        HashMap<Integer, Float> hashMap = new HashMap<Integer, Float>(75);
        Object object = this.library.getObject(this.entries, "W");
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = vector.size() - 1;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                Object e = vector.get(i);
                Object e2 = vector.get(i + 1);
                if (e instanceof Integer && e2 instanceof Vector) {
                    n3 = (Integer)e;
                    Vector vector2 = (Vector)e2;
                    int n4 = vector2.size();
                    for (n2 = 0; n2 < n4; ++n2) {
                        if (vector2.get(n2) instanceof Integer) {
                            hashMap.put(n3 + n2, Float.valueOf((float)((Integer)vector2.get(n2)).intValue() / 1000.0f));
                            continue;
                        }
                        if (!(vector2.get(n2) instanceof Float)) continue;
                        hashMap.put(n3 + n2, Float.valueOf(((Float)vector2.get(n2)).floatValue() / 1000.0f));
                    }
                    ++i;
                }
                if (!(e instanceof Integer) || !(e2 instanceof Integer)) continue;
                n2 = (Integer)e;
                while (n2 <= (Integer)e2) {
                    n3 = n2++;
                    hashMap.put(n3, Float.valueOf((float)((Integer)vector.get(i + 2)).intValue() / 1000.0f));
                }
                i += 2;
            }
        }
        return hashMap;
    }
}

