/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.ContentParser;
import org.icepdf.core.util.Library;

public class Form
extends Stream {
    private static final Logger logger = Logger.getLogger(Form.class.toString());
    private AffineTransform matrix = new AffineTransform();
    private Rectangle2D bbox;
    private Shapes shapes;
    private GraphicsState graphicsState;
    private Resources resources;
    private Resources parentResource;
    private boolean inited = false;

    public Form(Library library, Hashtable hashtable, SeekableInputConstrainedWrapper seekableInputConstrainedWrapper) {
        super(library, hashtable, seekableInputConstrainedWrapper);
    }

    public void dispose(boolean bl) {
        if (this.shapes != null) {
            this.shapes.dispose();
        }
        if (this.resources != null) {
            this.resources.dispose(bl);
        }
        if (this.parentResource != null) {
            this.parentResource = null;
        }
        this.inited = false;
        this.graphicsState = null;
    }

    public void setGraphicsState(GraphicsState graphicsState) {
        if (graphicsState != null) {
            this.graphicsState = graphicsState;
        }
    }

    private static AffineTransform getAffineTransform(Vector vector) {
        float[] fArray = new float[6];
        for (int i = 0; i < 6; ++i) {
            fArray[i] = ((Number)vector.elementAt(i)).floatValue();
        }
        return new AffineTransform(fArray);
    }

    public void setParentResources(Resources resources) {
        this.parentResource = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.inited) {
            return;
        }
        Vector vector = (Vector)this.library.getObject(this.entries, "Matrix");
        if (vector != null) {
            this.matrix = Form.getAffineTransform(vector);
        }
        this.bbox = this.library.getRectangle(this.entries, "BBox");
        Resources resources = this.library.getResources(this.entries, "Resources");
        if (resources != null) {
            this.resources = resources;
        } else {
            resources = this.parentResource;
        }
        ContentParser contentParser = new ContentParser(this.library, resources);
        contentParser.setGraphicsState(this.graphicsState);
        InputStream inputStream = this.getInputStreamForDecodedStreamBytes();
        if (inputStream != null) {
            try {
                this.shapes = contentParser.parse(inputStream);
            }
            catch (Throwable throwable) {
                this.shapes = new Shapes();
                logger.log(Level.FINE, "Error parsing Form content stream.", throwable);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.inited = true;
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public Rectangle2D getBBox() {
        return this.bbox;
    }

    public AffineTransform getMatrix() {
        return this.matrix;
    }
}

