/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class XPathPredicate
implements XSLExprConstants {
    FastVector predicates;
    private int predicateSize;
    private int position = -1;
    private int simpleCtx = -1;
    static final int OTHER_TEST = 0;
    static final int CHILD_VALUE = 1;
    static final int ATTR_VALUE = 2;
    static final int POSITION_TEST = 3;

    XPathPredicate(XSLParseString xSLParseString) throws XSLException, XQException {
        boolean bl = xSLParseString.isPattern();
        xSLParseString.setPattern(false);
        this.predicates = new FastVector(5);
        while (xSLParseString.peekToken() == 27) {
            xSLParseString.nextToken();
            this.predicates.addElement(XSLExpr.parse(xSLParseString));
            if (xSLParseString.nextToken() == 28) continue;
            throw new XPathException(1019, "]", xSLParseString.getCurrentToken());
        }
        this.predicateSize = this.predicates.size();
        xSLParseString.setPattern(bl);
    }

    void cacheSubExpr() throws XQException {
        for (int i = 0; i < this.predicateSize; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i);
            if (!xSLExprBase.canCacheExpr()) continue;
            this.predicates.setElementAt(xSLExprBase.createCachedExpr(), i);
        }
    }

    boolean canCacheExpr() {
        for (int i = 0; i < this.predicateSize; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i);
            if (xSLExprBase.canCacheExpr()) continue;
            return false;
        }
        return true;
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.predicateSize; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i);
            stringBuffer.append('[');
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    boolean isSimpleContext() {
        if (this.simpleCtx == -1) {
            this.simpleCtx = 0;
            for (int i = 0; i < this.predicateSize; ++i) {
                XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i);
                if (!xSLExprBase.isExprType(1048632) && !xSLExprBase.checkPosLastFN()) continue;
                this.simpleCtx = 1;
                break;
            }
        }
        return this.simpleCtx == 0;
    }

    int getPositionTest() throws XSLException, XQException {
        if (this.position != -1) {
            return this.position;
        }
        XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(0);
        this.position = xSLExprBase.getPositionTest();
        return this.position;
    }

    void filter(OXMLSequence oXMLSequence, XSLTContext xSLTContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence2 = xSLTContext.pushExprValue();
        int n = xSLTContext.setContextSize(XPathSequence.getLength(oXMLSequence));
        int n2 = xSLTContext.getContextPosition();
        XMLNode xMLNode = xSLTContext.getContextNode();
        for (int i = 0; i < this.predicateSize; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i);
            oXMLSequence2.reset();
            int n3 = 1;
            while (oXMLSequence.next()) {
                XMLNode xMLNode2 = XPathSequence.nextNode(oXMLSequence);
                xSLTContext.setContextNode(xMLNode2);
                xSLTContext.setContextPosition(n3);
                xSLExprBase.evaluate(xSLTContext);
                OXMLSequence oXMLSequence3 = xSLTContext.popExprValue();
                if (oXMLSequence3.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE)) {
                    if (XPathSequence.getNumberValue(oXMLSequence3) == (double)n3) {
                        XPathSequence.addNode(oXMLSequence2, xMLNode2);
                        break;
                    }
                } else if (XPathSequence.getBooleanValue(oXMLSequence3)) {
                    XPathSequence.addNode(oXMLSequence2, xMLNode2);
                }
                ++n3;
            }
            xSLTContext.setContextSize(XPathSequence.getLength(oXMLSequence2));
            oXMLSequence.reset();
            XPathSequence.concatSequence(oXMLSequence, oXMLSequence2);
        }
        xSLTContext.setContextSize(n);
        xSLTContext.setContextPosition(n2);
        xSLTContext.setContextNode(xMLNode);
        xSLTContext.popExprValue();
    }

    boolean filterNode(XMLNode xMLNode, XSLTContext xSLTContext) throws XSLException, XQException {
        XMLNode xMLNode2 = xSLTContext.getContextNode();
        xSLTContext.setContextNode(xMLNode);
        for (int i = 0; i < this.predicateSize; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i);
            xSLExprBase.evaluate(xSLTContext);
            if (XPathSequence.getBooleanValue(xSLTContext.popExprValue())) continue;
            xSLTContext.setContextNode(xMLNode2);
            return false;
        }
        xSLTContext.setContextNode(xMLNode2);
        return true;
    }
}

