/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.edit.PDPageContentStream;
import org.pdfbox.pdmodel.font.PDSimpleFont;
import org.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.pdfbox.pdmodel.font.PDType1Font;

public class TextToPDF {
    private int fontSize = 10;
    private PDSimpleFont font = PDType1Font.HELVETICA;

    public PDDocument createPDFFromText(PDDocument doc, Reader text) throws IOException {
        try {
            int margin = 40;
            float height = this.font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f;
            height = height * (float)this.fontSize * 1.05f;
            doc = new PDDocument();
            BufferedReader data = new BufferedReader(text);
            String nextLine = null;
            PDPage page = new PDPage();
            PDPageContentStream contentStream = null;
            float y = -1.0f;
            float maxStringLength = page.getMediaBox().getWidth() - (float)(2 * margin);
            while ((nextLine = data.readLine()) != null) {
                String[] lineWords = nextLine.trim().split(" ");
                int lineIndex = 0;
                while (lineIndex < lineWords.length) {
                    StringBuffer nextLineToDraw = new StringBuffer();
                    float lengthIfUsingNextWord = 0.0f;
                    do {
                        nextLineToDraw.append(lineWords[lineIndex]);
                        nextLineToDraw.append(" ");
                        if (++lineIndex >= lineWords.length) continue;
                        String lineWithNextWord = nextLineToDraw.toString() + lineWords[lineIndex];
                        lengthIfUsingNextWord = this.font.getStringWidth(lineWithNextWord) / 1000.0f * (float)this.fontSize;
                    } while (lineIndex < lineWords.length && lengthIfUsingNextWord < maxStringLength);
                    if (y < (float)margin) {
                        page = new PDPage();
                        doc.addPage(page);
                        if (contentStream != null) {
                            contentStream.endText();
                            contentStream.close();
                        }
                        contentStream = new PDPageContentStream(doc, page);
                        contentStream.setFont(this.font, this.fontSize);
                        contentStream.beginText();
                        y = page.getMediaBox().getHeight() - (float)margin + height;
                        contentStream.moveTextPositionByAmount(margin, y);
                    }
                    contentStream.moveTextPositionByAmount(0.0f, -height);
                    y -= height;
                    contentStream.drawString(nextLineToDraw.toString());
                }
            }
            if (contentStream != null) {
                contentStream.endText();
                contentStream.close();
            }
        }
        catch (IOException io) {
            if (doc != null) {
                doc.close();
            }
            throw io;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        TextToPDF app = new TextToPDF();
        PDDocument doc = null;
        try {
            doc = new PDDocument();
            if (args.length < 2) {
                app.usage();
            } else {
                for (int i = 0; i < args.length - 2; ++i) {
                    if (args[i].equals("-standardFont")) {
                        app.setFont(PDType1Font.getStandardFont(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-ttf")) {
                        PDTrueTypeFont font = PDTrueTypeFont.loadTTF(doc, new File(args[++i]));
                        app.setFont(font);
                        continue;
                    }
                    if (args[i].equals("-fontSize")) {
                        app.setFontSize(Integer.parseInt(args[++i]));
                        continue;
                    }
                    throw new IOException("Unknown argument:" + args[i]);
                }
                doc = app.createPDFFromText(doc, new FileReader(args[args.length - 1]));
                doc.save(args[args.length - 2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    private void usage() {
        String[] std14 = PDType1Font.getStandard14Names();
        System.err.println("usage: " + this.getClass().getName() + " [options] <output-file> <text-file>");
        System.err.println("    -standardFont <name>    default:" + PDType1Font.HELVETICA.getBaseFont());
        for (int i = 0; i < std14.length; ++i) {
            System.err.println("                                    " + std14[i]);
        }
        System.err.println("    -ttf <ttf file>         The TTF font to use.");
        System.err.println("    -fontSize <fontSize>    default:10");
    }

    public PDSimpleFont getFont() {
        return this.font;
    }

    public void setFont(PDSimpleFont aFont) {
        this.font = aFont;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int aFontSize) {
        this.fontSize = aFontSize;
    }
}

