/*
 * Decompiled with CFR 0.152.
 */
package railo.extension.io.log.sl4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.spi.LocationAwareLogger;
import railo.extension.io.log.sl4j.LoggerFactoryImpl;
import railo.loader.engine.CFMLEngine;
import railo.loader.util.Util;
import railo.runtime.util.Cast;

public class LoggerAdapterConsole
extends MarkerIgnoringBase
implements LocationAwareLogger {
    private static final long serialVersionUID = 161763258138937969L;
    private String _name;
    private int level;
    private static Cast cast;

    public LoggerAdapterConsole(String name, int level) {
        this._name = name;
        this.level = level;
    }

    public void debug(String msg) {
        this.log(1, msg);
    }

    public void error(String msg) {
        this.log(3, msg);
    }

    public void info(String msg) {
        this.log(0, msg);
    }

    public void trace(String msg) {
    }

    public void warn(String msg) {
        this.log(2, msg);
    }

    public void debug(String format, Object arg) {
        this.log(1, format, arg);
    }

    public void error(String format, Object arg) {
        this.log(3, format, arg);
    }

    public void info(String format, Object arg) {
        this.log(0, format, arg);
    }

    public void trace(String format, Object arg) {
    }

    public void warn(String format, Object arg) {
        this.log(2, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void trace(String format, Object arg1, Object arg2) {
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void debug(String format, Object[] args) {
        this.log(1, format, args);
    }

    public void error(String format, Object[] args) {
        this.log(1, format, args);
    }

    public void info(String format, Object[] args) {
        this.log(1, format, args);
    }

    public void trace(String format, Object[] args) {
    }

    public void warn(String format, Object[] args) {
        this.log(1, format, args);
    }

    public void debug(String msg, Throwable t) {
        this.log(1, msg, t);
    }

    public void error(String msg, Throwable t) {
        this.log(1, msg, t);
    }

    public void info(String msg, Throwable t) {
        this.log(1, msg, t);
    }

    public void trace(String msg, Throwable t) {
    }

    public void warn(String msg, Throwable t) {
        this.log(1, msg, t);
    }

    private void log(int level, String msg) {
        if (this.level <= level) {
            System.out.print(String.valueOf(this._name) + ":" + msg);
        }
    }

    private void log(int level, String msg, Throwable t) {
        this.log(level, String.valueOf(msg) + "\n" + LoggerAdapterConsole.getStacktrace(t, true));
    }

    private void log(int level, String format, Object arg) {
        this.log(level, LoggerAdapterConsole.toString(arg));
    }

    private void log(int level, String format, Object arg1, Object arg2) {
        this.log(level, String.valueOf(LoggerAdapterConsole.toString(arg1)) + "\n" + LoggerAdapterConsole.toString(arg2));
    }

    private void log(int level, String format, Object[] args) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            sb.append(LoggerAdapterConsole.toString(args[i]));
            sb.append("\n");
            ++i;
        }
        this.log(level, sb.toString().trim());
    }

    public boolean isDebugEnabled() {
        return this.level <= 1;
    }

    public boolean isErrorEnabled() {
        return this.level <= 3;
    }

    public boolean isInfoEnabled() {
        return this.level <= 0;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return this.level <= 2;
    }

    public void log(Marker marker, String arg1, int arg2, String arg3, Throwable arg4) {
    }

    public static String getStacktrace(Throwable t, boolean addMessage) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        String st = sw.toString();
        String msg = t.getMessage();
        if (addMessage && !Util.isEmpty((String)msg) && !st.startsWith(msg.trim())) {
            st = String.valueOf(msg) + "\n" + st;
        }
        return st;
    }

    public static String toString(Object arg) {
        if (arg == null) {
            return "";
        }
        try {
            CFMLEngine engine;
            if (cast == null && (engine = LoggerFactoryImpl.getCFMLEngine()) != null) {
                cast = engine.getCastUtil();
            }
            if (cast != null) {
                return cast.toString(arg, "");
            }
            return arg.toString();
        }
        catch (Throwable t) {
            return "";
        }
    }
}

