/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.mpg;

import java.io.IOException;
import java.util.HashMap;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import net.sourceforge.jffmpeg.demux.mpg.MpegAC3AudioTrack;
import net.sourceforge.jffmpeg.demux.mpg.MpegAudioTrack;
import net.sourceforge.jffmpeg.demux.mpg.MpegVideoTrack;

public class MpegDemux
implements Demultiplexer,
Positionable {
    public static final int PACKET_START_CODE_MASK = -256;
    public static final int PACKET_START_CODE_PREFIX = 256;
    public static final int SEQUENCE_START_CODE = 435;
    public static final int EXT_START_CODE = 437;
    public static final int SEQUENCE_END_CODE = 439;
    public static final int GOP_START_CODE = 440;
    public static final int ISO_11172_END_CODE = 441;
    public static final int PACK_START_CODE = 442;
    public static final int SYSTEM_HEADER_START_CODE = 443;
    public static final int PROGRAM_STREAM_MAP = 444;
    public static final int PRIVATE_STREAM_1 = 445;
    public static final int PADDING_STREAM = 446;
    public static final int PRIVATE_STREAM_2 = 447;
    private PullSourceStream in;
    private Seekable seek;
    private HashMap tracks = new HashMap();
    private byte[] scratch = new byte[4];
    private static final int PACKET_READ_SIZE = 1024;

    public void open() throws ResourceUnavailableException {
    }

    public void reset() {
    }

    public void close() {
    }

    public synchronized void start() throws IOException {
    }

    public void stop() {
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return new Time(0L);
    }

    public Time getMediaTime() {
        return new Time(0L);
    }

    public String getName() {
        return "Mpeg Demultiplexer";
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return new ContentDescriptor[]{new FileTypeDescriptor("video.mpegt")};
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks.size() == 0) {
            MpegVideoTrack mpegVideoTrack = new MpegVideoTrack(this, 480);
            mpegVideoTrack.readFrame(new Buffer());
            mpegVideoTrack.readFrame(new Buffer());
            mpegVideoTrack.readFrame(new Buffer());
        }
        return this.tracks.values().toArray(new Track[0]);
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return true;
    }

    public Time setPosition(Time time, int n) {
        return time;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (dataSource instanceof PullDataSource) {
            this.in = ((PullDataSource)dataSource).getStreams()[0];
            if (this.in instanceof Seekable) {
                if (this.in.getContentLength() != -1L) {
                    this.seek = (Seekable)this.in;
                }
            }
            return;
        }
        throw new IncompatibleSourceException();
    }

    protected synchronized int peekPacket(long l) throws IOException {
        l = this.seek.seek(l);
        this.in.read(this.scratch, 0, 4);
        int n = (this.scratch[0] & 0xFF) << 24 | (this.scratch[1] & 0xFF) << 16 | (this.scratch[2] & 0xFF) << 8 | this.scratch[3] & 0xFF;
        this.seek.seek(l);
        return n;
    }

    protected synchronized long skipPacket(long l) throws IOException {
        l = this.seek.seek(l + 1L);
        int n = -1;
        while ((n | 0xFF) != 511 && n != 0) {
            this.in.read(this.scratch, 0, 1);
            n = (n << 8 | 0xFF & this.scratch[0]) & 0xFFFFFFFF;
            ++l;
        }
        return l - 4L;
    }

    protected synchronized long readPacket(Buffer buffer, int n, long l) throws IOException {
        byte[] byArray = (byte[])buffer.getData();
        if (byArray == null || byArray.length < 100000) {
            byArray = new byte[1000000];
            buffer.setData((Object)byArray);
        }
        l = this.seek.seek(l);
        int n2 = buffer.getLength();
        this.in.read(byArray, n2, 4);
        n2 += 4;
        l += 4L;
        int n3 = 0;
        int n4 = -1;
        while ((n4 | 0xFF) != 511) {
            if (n3 % 1024 == 0) {
                this.in.read(byArray, n2, 1024);
            }
            ++l;
            ++n3;
            n4 = (n4 << 8 | 0xFF & byArray[++n2 - 1]) & 0xFFFFFFFF;
        }
        buffer.setData((Object)byArray);
        buffer.setLength(n2 - 4);
        return l -= 4L;
    }

    protected synchronized long skipDTSPacket(long l) throws IOException {
        this.readDTSHeader(null, l);
        l = this.seek.seek(l + 4L);
        this.in.read(this.scratch, 0, 2);
        int n = (this.scratch[0] & 0xFF) << 8 | this.scratch[1] & 0xFF;
        return (l += 2L) + (long)n;
    }

    private long get_pts(int n) throws IOException {
        if (n < 0) {
            this.in.read(this.scratch, 0, 1);
            n = this.scratch[0] & 0xFF;
        }
        this.in.read(this.scratch, 0, 4);
        long l = (long)(n >> 1 & 7) << 30;
        int n2 = (this.scratch[0] & 0xFF) << 8 | this.scratch[1] & 0xFF;
        l |= (long)(n2 >> 1) << 15;
        n2 = (this.scratch[2] & 0xFF) << 8 | this.scratch[3] & 0xFF;
        return l |= (long)(n2 >> 1);
    }

    protected synchronized long readDTSHeader(Buffer buffer, long l) throws IOException {
        return this.readDTSPacket(buffer, 0, l, true);
    }

    protected synchronized long readDTSPacket(Buffer buffer, int n, long l) throws IOException {
        return this.readDTSPacket(buffer, n, l, false);
    }

    private synchronized long readDTSPacket(Buffer buffer, int n, long l, boolean bl) throws IOException {
        int n2;
        int n3;
        byte[] byArray = null;
        if (buffer != null && ((byArray = (byte[])buffer.getData()) == null || byArray.length < 100000)) {
            byArray = new byte[1000000];
        }
        l = this.seek.seek(l);
        int n4 = this.peekPacket(l);
        this.in.read(this.scratch, 0, 4);
        l += 4L;
        this.in.read(this.scratch, 0, 2);
        l += 2L;
        int n5 = (this.scratch[0] & 0xFF) << 8 | this.scratch[1] & 0xFF;
        long l2 = -1L;
        long l3 = -1L;
        do {
            this.in.read(this.scratch, 0, 1);
            ++l;
            --n5;
        } while ((n3 = this.scratch[0] & 0xFF) == 255);
        if ((n3 & 0xC0) == 64) {
            this.in.read(this.scratch, 0, 2);
            l += 2L;
            n5 -= 2;
            n3 = this.scratch[1] & 0xFF;
        }
        if ((n3 & 0xF0) == 32) {
            l3 = l2 = this.get_pts(n3);
            n5 -= 4;
            l += 4L;
        } else if ((n3 & 0xF0) == 48) {
            l3 = this.get_pts(n3);
            l2 = this.get_pts(-1);
            n5 -= 9;
            l += 4L;
        } else if ((n3 & 0xC0) == 128) {
            if ((n3 & 0x30) != 0) {
                throw new IOException("Encrypted streams are not handled");
            }
            this.in.read(this.scratch, 0, 2);
            l += 2L;
            n2 = this.scratch[0] & 0xFF;
            int n6 = this.scratch[1] & 0xFF;
            if (n6 > (n5 -= 2)) {
                throw new IOException("Invalid Header");
            }
            if ((n2 & 0xC0) == 128) {
                l3 = l2 = this.get_pts(-1);
                if (n6 < 5) {
                    throw new IOException("Invalid Header");
                }
                n6 -= 5;
                n5 -= 5;
                l += 5L;
            }
            if ((n2 & 0xC0) == 192) {
                l3 = this.get_pts(-1);
                l2 = this.get_pts(-1);
                if (n6 < 10) {
                    throw new IOException("Invalid Header");
                }
                n6 -= 10;
                n5 -= 10;
                l += 10L;
            }
            n5 -= n6;
            l += (long)n6;
            while (n6 > 0) {
                this.in.read(this.scratch, 0, 1);
                --n6;
            }
        } else if (n3 != 15) {
            throw new IOException("Invalid Header");
        }
        if (n4 == 445) {
            if (n5 < 1) {
                throw new IOException("Invalid Header");
            }
            this.in.read(this.scratch, 0, 1);
            --n5;
            ++l;
            n4 = this.scratch[0] & 0xFF;
            if (n4 >= 128 && n4 <= 191) {
                if (n5 < 3) {
                    throw new IOException("Invalid Header");
                }
                this.in.read(this.scratch, 0, 3);
                n5 -= 3;
                l += 3L;
            }
            if (n != n4 && !bl) {
                bl = true;
                l += (long)n5;
            }
        }
        if (l3 >= 0L) {
            // empty if block
        }
        if (!bl) {
            n2 = buffer.getLength();
            this.in.read(byArray, n2, n5);
            l += (long)n5;
            buffer.setData((Object)byArray);
            buffer.setLength(n2 += n5);
        } else if (!this.tracks.containsKey(new Integer(n4))) {
            System.out.println("Add track " + n4);
            if (n4 >= 480 && n4 <= 495) {
                this.tracks.put(new Integer(n4), new MpegVideoTrack(this, n4));
            } else if (n4 >= 448 && n4 <= 479) {
                this.tracks.put(new Integer(n4), new MpegAudioTrack(this, n4));
            } else if (n4 >= 128 && n4 <= 159) {
                this.tracks.put(new Integer(n4), new MpegAC3AudioTrack(this, 445, n4));
            } else if (n4 < 160 || n4 <= 191) {
                // empty if block
            }
        }
        return l;
    }
}

