/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.vorbis.floor;

import net.sourceforge.jffmpeg.codecs.audio.vorbis.CodeBook;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.OggReader;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.VorbisDecoder;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.floor.Floor;

public class Floor0
extends Floor {
    private int order;
    private int rate;
    private int barkmap;
    private int ampbits;
    private int ampdB;
    private int numbooks;
    private int[] books;
    private int ln;
    private int m;
    private int[][] linearmap;
    private int[] n;
    private float[] lsp_look;
    private long bits;
    private long frames;

    public void unpack(OggReader oggReader) {
        this.order = (int)oggReader.getBits(8);
        this.rate = (int)oggReader.getBits(16);
        this.barkmap = (int)oggReader.getBits(16);
        this.ampbits = (int)oggReader.getBits(6);
        this.ampdB = (int)oggReader.getBits(8);
        this.numbooks = (int)oggReader.getBits(4) + 1;
        this.books = new int[this.numbooks];
        for (int i = 0; i < this.numbooks; ++i) {
            this.books[i] = (int)oggReader.getBits(8);
        }
    }

    private static final int _ilog(long l) {
        int n = 0;
        while (l > 0L) {
            ++n;
            l >>= 1;
        }
        return n;
    }

    public void look() {
    }

    public Object inverse1(OggReader oggReader, VorbisDecoder vorbisDecoder) {
        System.out.println("Floor0 inverse1");
        int n = (int)oggReader.getBits(this.ampbits);
        if (n > 0) {
            long l = (1 << this.ampbits) - 1;
            float f = (float)n / (float)l * (float)this.ampdB;
            int n2 = (int)oggReader.getBits(Floor0._ilog(this.numbooks));
            if (n2 < this.numbooks) {
                int n3;
                CodeBook codeBook = vorbisDecoder.getCodeBook(n2);
                float f2 = 0.0f;
                int n4 = codeBook.getDim();
                float[] fArray = new float[this.m + n4 + 1];
                for (n3 = 0; n3 < this.m; n3 += n4) {
                    codeBook.decodev_set(fArray, n3, oggReader, n4);
                }
                n3 = 0;
                while (n3 < this.m) {
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = n3;
                        fArray[n6] = fArray[n6] + f2;
                        f2 = fArray[n3 - 1];
                        ++n5;
                        ++n3;
                    }
                }
                fArray[this.m] = f;
                return fArray;
            }
        }
        throw new Error("Bad value");
    }

    public void inverse2(Object object, float[] fArray, VorbisDecoder vorbisDecoder) {
        System.out.println("Floor0 inverse2");
        float[] fArray2 = (float[])object;
        float f = fArray2[this.m];
    }
}

