/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.RemoteCacheException;

public class RMISynchronousCacheReplicator
implements CacheReplicator {
    private static final Logger LOG = Logger.getLogger(RMISynchronousCacheReplicator.class.getName());
    protected Status status;
    protected final boolean replicatePuts;
    protected final boolean replicateUpdates;
    protected final boolean replicateUpdatesViaCopy;
    protected final boolean replicateRemovals;

    public RMISynchronousCacheReplicator(boolean replicatePuts, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals) {
        this.replicatePuts = replicatePuts;
        this.replicateUpdates = replicateUpdates;
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
        this.replicateRemovals = replicateRemovals;
        this.status = Status.STATUS_ALIVE;
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicatePuts) {
            return;
        }
        if (!element.isSerializable()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Object with key " + element.getObjectKey() + " is not Serializable and cannot be replicated");
            }
            return;
        }
        RMISynchronousCacheReplicator.replicatePutNotification(cache, element);
    }

    private static void replicatePutNotification(Ehcache cache, Element element) throws RemoteCacheException {
        List cachePeers = RMISynchronousCacheReplicator.listRemoteCachePeers(cache);
        for (int i = 0; i < cachePeers.size(); ++i) {
            CachePeer cachePeer = (CachePeer)cachePeers.get(i);
            try {
                cachePeer.put(element);
                continue;
            }
            catch (Throwable t) {
                throw new RemoteCacheException("Error doing put to remote peer. Message was: " + t.getMessage());
            }
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            if (!element.isSerializable()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Object with key " + element.getObjectKey() + " is not Serializable and cannot be updated via copy");
                }
                return;
            }
            RMISynchronousCacheReplicator.replicatePutNotification(cache, element);
        } else {
            if (!element.isKeySerializable()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
                }
                return;
            }
            RMISynchronousCacheReplicator.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
        }
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        if (!element.isKeySerializable()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
            }
            return;
        }
        RMISynchronousCacheReplicator.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
    }

    private static void replicateRemovalNotification(Ehcache cache, Serializable key) throws RemoteCacheException {
        List cachePeers = RMISynchronousCacheReplicator.listRemoteCachePeers(cache);
        for (int i = 0; i < cachePeers.size(); ++i) {
            CachePeer cachePeer = (CachePeer)cachePeers.get(i);
            try {
                cachePeer.remove(key);
                continue;
            }
            catch (Throwable e) {
                throw new RemoteCacheException("Error doing remove to remote peer. Message was: " + e.getMessage());
            }
        }
    }

    public final void notifyElementExpired(Ehcache cache, Element element) {
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        this.replicateRemoveAllNotification(cache);
    }

    private void replicateRemoveAllNotification(Ehcache cache) {
        List cachePeers = RMISynchronousCacheReplicator.listRemoteCachePeers(cache);
        for (int i = 0; i < cachePeers.size(); ++i) {
            CachePeer cachePeer = (CachePeer)cachePeers.get(i);
            try {
                cachePeer.removeAll();
                continue;
            }
            catch (Throwable e) {
                throw new RemoteCacheException("Error doing removeAll to remote peer. Message was: " + e.getMessage());
            }
        }
    }

    static List listRemoteCachePeers(Ehcache cache) {
        CacheManagerPeerProvider provider = cache.getCacheManager().getCacheManagerPeerProvider("RMI");
        return provider.listRemoteCachePeers(cache);
    }

    public final boolean isReplicateUpdatesViaCopy() {
        return this.replicateUpdatesViaCopy;
    }

    public final boolean notAlive() {
        return !this.alive();
    }

    public final boolean alive() {
        if (this.status == null) {
            return false;
        }
        return this.status.equals(Status.STATUS_ALIVE);
    }

    public void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new RMISynchronousCacheReplicator(this.replicatePuts, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals);
    }
}

