/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.el.GreekCharsets;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public final class GreekAnalyzer
extends Analyzer {
    private static char A = (char)6;
    private static char B = (char)7;
    private static char G = (char)8;
    private static char D = (char)9;
    private static char E = (char)10;
    private static char Z = (char)11;
    private static char H = (char)12;
    private static char TH = (char)13;
    private static char I = (char)14;
    private static char K = (char)15;
    private static char L = (char)16;
    private static char M = (char)17;
    private static char N = (char)18;
    private static char KS = (char)19;
    private static char O = (char)20;
    private static char P = (char)21;
    private static char R = (char)22;
    private static char S = (char)24;
    private static char T = (char)25;
    private static char Y = (char)26;
    private static char F = (char)27;
    private static char X = (char)28;
    private static char PS = (char)29;
    private static char W = (char)30;
    private static char[][] GREEK_STOP_WORDS = new char[][]{{O}, {H}, {T, O}, {O, I}, {T, A}, {T, O, Y}, {T, H, S}, {T, W, N}, {T, O, N}, {T, H, N}, {K, A, I}, {K, I}, {K}, {E, I, M, A, I}, {E, I, S, A, I}, {E, I, N, A, I}, {E, I, M, A, S, T, E}, {E, I, S, T, E}, {S, T, O}, {S, T, O, N}, {S, T, H}, {S, T, H, N}, {M, A}, {A, L, L, A}, {A, P, O}, {G, I, A}, {P, R, O, S}, {M, E}, {S, E}, {W, S}, {P, A, R, A}, {A, N, T, I}, {K, A, T, A}, {M, E, T, A}, {TH, A}, {N, A}, {D, E}, {D, E, N}, {M, H}, {M, H, N}, {E, P, I}, {E, N, W}, {E, A, N}, {A, N}, {T, O, T, E}, {P, O, Y}, {P, W, S}, {P, O, I, O, S}, {P, O, I, A}, {P, O, I, O}, {P, O, I, O, I}, {P, O, I, E, S}, {P, O, I, W, N}, {P, O, I, O, Y, S}, {A, Y, T, O, S}, {A, Y, T, H}, {A, Y, T, O}, {A, Y, T, O, I}, {A, Y, T, W, N}, {A, Y, T, O, Y, S}, {A, Y, T, E, S}, {A, Y, T, A}, {E, K, E, I, N, O, S}, {E, K, E, I, N, H}, {E, K, E, I, N, O}, {E, K, E, I, N, O, I}, {E, K, E, I, N, E, S}, {E, K, E, I, N, A}, {E, K, E, I, N, W, N}, {E, K, E, I, N, O, Y, S}, {O, P, W, S}, {O, M, W, S}, {I, S, W, S}, {O, S, O}, {O, T, I}};
    private Set stopSet = new HashSet();
    private char[] charset;

    public GreekAnalyzer() {
        this.charset = GreekCharsets.UnicodeGreek;
        this.stopSet = StopFilter.makeStopSet((String[])GreekAnalyzer.makeStopWords(GreekCharsets.UnicodeGreek));
    }

    public GreekAnalyzer(char[] charset) {
        this.charset = charset;
        this.stopSet = StopFilter.makeStopSet((String[])GreekAnalyzer.makeStopWords(charset));
    }

    public GreekAnalyzer(char[] charset, String[] stopwords) {
        this.charset = charset;
        this.stopSet = StopFilter.makeStopSet((String[])stopwords);
    }

    private static String[] makeStopWords(char[] charset) {
        String[] res = new String[GREEK_STOP_WORDS.length];
        for (int i = 0; i < res.length; ++i) {
            char[] theStopWord = GREEK_STOP_WORDS[i];
            StringBuffer theWord = new StringBuffer();
            for (int j = 0; j < theStopWord.length; ++j) {
                theWord.append(charset[theStopWord[j]]);
            }
            res[i] = theWord.toString();
        }
        return res;
    }

    public GreekAnalyzer(char[] charset, Map stopwords) {
        this.charset = charset;
        this.stopSet = new HashSet(stopwords.keySet());
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new GreekLowerCaseFilter((TokenStream)result, this.charset);
        result = new StopFilter((TokenStream)result, this.stopSet);
        return result;
    }
}

