/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.compress.CompressUtils;
import org.apache.commons.compress.PackableObjectException;

public abstract class PackableObject {
    protected static final int CHOOSE_EXTENSION = 1;
    protected static final int CHOOSE_NAME = 2;

    public abstract byte[] getHeader();

    public abstract String getDefaultFileExtension();

    public abstract String getName();

    protected boolean isPackableWith(Object value, int choose) {
        if (value == null) {
            return false;
        }
        return choose == 1 ? value.equals(this.getDefaultFileExtension()) : choose == 2 && value.equals(this.getName());
    }

    public static PackableObject identifyByHeader(File file, List packables) throws PackableObjectException {
        FileInputStream fis = null;
        try {
            Object packable = null;
            fis = new FileInputStream(file);
            byte[] headerBytes = new byte[20];
            fis.read(headerBytes, 0, 20);
            Iterator iter = packables.iterator();
            while (iter.hasNext()) {
                PackableObject p = (PackableObject)iter.next();
                byte[] fieldHeader = p.getHeader();
                if (fieldHeader == null || !CompressUtils.compareByteArrays(headerBytes, fieldHeader)) continue;
                PackableObject packableObject = p;
                return packableObject;
            }
            String name = file.getName();
            String extension = null;
            String[] s = name.split("\\.");
            if (s.length > 1) {
                extension = s[s.length - 1];
            }
            Iterator it = packables.iterator();
            while (it.hasNext()) {
                PackableObject p = (PackableObject)it.next();
                if (!p.isPackableWith(extension, 1)) continue;
                PackableObject packableObject = p;
                return packableObject;
            }
            PackableObject packableObject = null;
            return packableObject;
        }
        catch (FileNotFoundException e) {
            throw new PackableObjectException("File not found", e);
        }
        catch (IOException e) {
            throw new PackableObjectException("Internal factory exception", e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e1) {
                throw new PackableObjectException("Error while closing InputStream to file", e1);
            }
        }
    }
}

