/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.compress.Archive;
import org.apache.commons.compress.ArchiveException;
import org.apache.commons.compress.PackableObject;
import org.apache.commons.compress.PackableObjectException;
import org.apache.commons.compress.archivers.tar.TarArchive;
import org.apache.commons.compress.archivers.zip.ZipArchive;

public class ArchiverFactory {
    private static List archives = new ArrayList();

    private ArchiverFactory() {
    }

    public static void registerArchiver(String className) throws ClassNotFoundException, ArchiveException {
        Class<?> clazz = Class.forName(className);
        ArchiverFactory.registerArchiver(clazz);
    }

    public static void registerArchiver(Class clazz) throws ArchiveException {
        if (Archive.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
            try {
                archives.add(clazz.newInstance());
            }
            catch (InstantiationException e) {
                throw new ArchiveException("Archive could not be instantiated", e);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveException("Archive could not be instantiated", e);
            }
        } else {
            throw new ArchiveException("Archive does not implement the Archive.class interface.");
        }
    }

    public static Archive getInstance(String archiverName) throws ArchiveException {
        try {
            if (archiverName == null) {
                throw new ArchiveException("ArchiverFactory could not create instance");
            }
            Iterator it = archives.iterator();
            while (it.hasNext()) {
                PackableObject po = (PackableObject)it.next();
                if (!po.isPackableWith(archiverName, 2)) continue;
                return (Archive)po.getClass().newInstance();
            }
            return null;
        }
        catch (InstantiationException e) {
            throw new ArchiveException("ArchiverFactory could not create instance", e);
        }
        catch (IllegalAccessException e) {
            throw new ArchiveException("ArchiverFactory could not create instance", e);
        }
    }

    public static Archive getInstance(File file) throws ArchiveException {
        if (file == null && !file.isFile()) {
            throw new ArchiveException("ArchiverFactory could not create instance for this file");
        }
        PackableObject packable = null;
        try {
            packable = PackableObject.identifyByHeader(file, archives);
            if (packable == null) {
                return null;
            }
            Archive archive = (Archive)packable.getClass().newInstance();
            archive.setArchive(file);
            return archive;
        }
        catch (SecurityException e) {
            throw new ArchiveException("A security violation occured while reading the field ARCHIVER_NAME", e);
        }
        catch (IllegalArgumentException e) {
            throw new ArchiveException("Internal factory exception", e);
        }
        catch (InstantiationException e) {
            throw new ArchiveException("ArchiverFactory could not create instance", e);
        }
        catch (IllegalAccessException e) {
            throw new ArchiveException("ArchiverFactory could not create instance", e);
        }
        catch (PackableObjectException e) {
            throw new ArchiveException("ArchiverFactory could not create instance", e);
        }
    }

    static {
        try {
            ArchiverFactory.registerArchiver(TarArchive.class);
            ArchiverFactory.registerArchiver(ZipArchive.class);
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }
}

