/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.CompressException;
import org.apache.commons.compress.Compressor;
import org.apache.commons.compress.PackableObject;

public abstract class AbstractCompressor
extends PackableObject
implements Compressor {
    public abstract String getDefaultFileExtension();

    public InputStream compress(FileInputStream input) throws CompressException {
        FileOutputStream outputStream = null;
        FileOutputStream tempFileOutputStream = null;
        try {
            File temp = File.createTempFile("commons_", "jkt");
            tempFileOutputStream = new FileOutputStream(temp);
            this.compressTo(input, tempFileOutputStream);
            FileInputStream fileInputStream = new FileInputStream(temp);
            return fileInputStream;
        }
        catch (IOException e) {
            throw new CompressException("An IO Exception has occured", e);
        }
        finally {
            try {
                tempFileOutputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                throw new CompressException("An IO Exception occured while closing the streams", e);
            }
        }
    }

    public void compressTo(File input, File output) throws CompressException {
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            inputStream = new FileInputStream(input);
            this.compressTo(inputStream, outputStream);
        }
        catch (FileNotFoundException e) {
            throw new CompressException("File not found", e);
        }
    }

    public void compressToHere(File input) throws CompressException {
        String pathToFile = input.getAbsolutePath().concat(".").concat(this.getDefaultFileExtension());
        File output = new File(pathToFile);
        this.compressTo(input, output);
    }

    public InputStream compress(File input) throws CompressException {
        try {
            return this.compress(new FileInputStream(input));
        }
        catch (FileNotFoundException e) {
            throw new CompressException("File could not be found.", e);
        }
    }

    public InputStream decompress(File input) throws CompressException {
        FileInputStream result;
        try {
            File temp = File.createTempFile("compress_", "jkt");
            this.decompressTo(input, temp);
            result = new FileInputStream(temp);
        }
        catch (IOException e) {
            throw new CompressException("Error while creating a temporary file", e);
        }
        return result;
    }

    public InputStream decompress(FileInputStream input) throws CompressException {
        FileInputStream result;
        try {
            File temp = File.createTempFile("compress_", "jkt");
            this.decompressTo(input, new FileOutputStream(temp));
            result = new FileInputStream(temp);
        }
        catch (IOException e) {
            throw new CompressException("Error while creating a temporary file", e);
        }
        return result;
    }

    public void decompressTo(File input, File output) throws CompressException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            inputStream = new FileInputStream(input);
            this.decompressTo(inputStream, outputStream);
        }
        catch (FileNotFoundException e) {
            throw new CompressException("File could not be found", e);
        }
        finally {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (IOException e1) {
                throw new CompressException("An I/O Exception has occured while closing a stream", e1);
            }
        }
    }
}

