/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import flex.messaging.security.AppServerLoginCommand;
import flex.messaging.security.OracleUser;
import flex.messaging.security.SecurityException;
import java.security.Principal;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.callback.JAZNCallbackHandler;

public class OracleLoginCommand
extends AppServerLoginCommand {
    public Principal doAuthentication(String username, Object credentials) throws SecurityException {
        OracleUser user;
        try {
            JAZNCallbackHandler callbackHandler = new JAZNCallbackHandler(JAZNConfig.getJAZNConfig(), null, username, this.extractPassword(credentials));
            LoginContext context = new LoginContext("oracle.security.jazn.oc4j.JAZNUserManager", (CallbackHandler)callbackHandler);
            user = new OracleUser(context);
        }
        catch (LoginException loginException) {
            throw this.wrapLoginException(loginException);
        }
        return user;
    }

    public boolean doAuthorization(Principal principal, List roles) throws SecurityException {
        boolean result = false;
        if (principal instanceof OracleUser) {
            OracleUser user = (OracleUser)principal;
            result = user.isMemberOf(roles);
        }
        return result;
    }

    public boolean logout(Principal principal) throws SecurityException {
        boolean result = false;
        if (principal instanceof OracleUser) {
            OracleUser user = (OracleUser)principal;
            try {
                user.logout();
                result = true;
            }
            catch (LoginException loginException) {
                throw this.wrapLoginException(loginException);
            }
        }
        return result;
    }

    private SecurityException wrapLoginException(LoginException exception) {
        SecurityException result = new SecurityException();
        result.setRootCause((Throwable)exception);
        return result;
    }
}

