/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization.work;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.envers.synchronization.work.FakeBidirectionalRelationWorkUnit;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.envers.synchronization.work.WorkUnitMergeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentCollectionChangeWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private final List<PersistentCollectionChangeData> collectionChanges;
    private final String referencingPropertyName;

    public PersistentCollectionChangeWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditConfiguration auditCfg, PersistentCollection collection, CollectionEntry collectionEntry, Serializable snapshot, Serializable id, String referencingPropertyName) {
        super(sessionImplementor, entityName, auditCfg, new PersistentCollectionChangeWorkUnitId(id, collectionEntry.getRole()));
        this.referencingPropertyName = referencingPropertyName;
        this.collectionChanges = auditCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().mapCollectionChanges(referencingPropertyName, collection, snapshot, id);
    }

    public PersistentCollectionChangeWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditConfiguration verCfg, Serializable id, List<PersistentCollectionChangeData> collectionChanges, String referencingPropertyName) {
        super(sessionImplementor, entityName, verCfg, id);
        this.collectionChanges = collectionChanges;
        this.referencingPropertyName = referencingPropertyName;
    }

    @Override
    public boolean containsWork() {
        return this.collectionChanges != null && this.collectionChanges.size() != 0;
    }

    @Override
    public Map<String, Object> generateData(Object revisionData) {
        throw new UnsupportedOperationException("Cannot generate data for a collection change work unit!");
    }

    @Override
    public void perform(Session session, Object revisionData) {
        AuditEntitiesConfiguration entitiesCfg = this.verCfg.getAuditEntCfg();
        for (PersistentCollectionChangeData persistentCollectionChangeData : this.collectionChanges) {
            ((Map)persistentCollectionChangeData.getData().get(entitiesCfg.getOriginalIdPropName())).put(entitiesCfg.getRevisionFieldName(), revisionData);
            session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
        }
    }

    public String getReferencingPropertyName() {
        return this.referencingPropertyName;
    }

    public List<PersistentCollectionChangeData> getCollectionChanges() {
        return this.collectionChanges;
    }

    @Override
    public AuditWorkUnit merge(AddWorkUnit second) {
        return null;
    }

    @Override
    public AuditWorkUnit merge(ModWorkUnit second) {
        return null;
    }

    @Override
    public AuditWorkUnit merge(DelWorkUnit second) {
        return null;
    }

    @Override
    public AuditWorkUnit merge(CollectionChangeWorkUnit second) {
        return null;
    }

    @Override
    public AuditWorkUnit merge(FakeBidirectionalRelationWorkUnit second) {
        return null;
    }

    @Override
    public AuditWorkUnit dispatch(WorkUnitMergeVisitor first) {
        if (first instanceof PersistentCollectionChangeWorkUnit) {
            PersistentCollectionChangeWorkUnit original = (PersistentCollectionChangeWorkUnit)first;
            HashMap<Object, PersistentCollectionChangeData> newChangesIdMap = new HashMap<Object, PersistentCollectionChangeData>();
            for (PersistentCollectionChangeData persistentCollectionChangeData : this.getCollectionChanges()) {
                newChangesIdMap.put(this.getOriginalId(persistentCollectionChangeData), persistentCollectionChangeData);
            }
            ArrayList<PersistentCollectionChangeData> mergedChanges = new ArrayList<PersistentCollectionChangeData>();
            for (PersistentCollectionChangeData originalCollectionChangeData : original.getCollectionChanges()) {
                if (newChangesIdMap.containsKey(this.getOriginalId(originalCollectionChangeData))) continue;
                mergedChanges.add(originalCollectionChangeData);
            }
            mergedChanges.addAll(this.getCollectionChanges());
            return new PersistentCollectionChangeWorkUnit(this.sessionImplementor, this.entityName, this.verCfg, this.id, mergedChanges, this.referencingPropertyName);
        }
        throw new RuntimeException("Trying to merge a " + first + " with a PersitentCollectionChangeWorkUnit. " + "This is not really possible.");
    }

    private Object getOriginalId(PersistentCollectionChangeData persistentCollectionChangeData) {
        return persistentCollectionChangeData.getData().get(this.verCfg.getAuditEntCfg().getOriginalIdPropName());
    }

    private static class PersistentCollectionChangeWorkUnitId
    implements Serializable {
        private static final long serialVersionUID = -8007831518629167537L;
        private final Serializable ownerId;
        private final String role;

        public PersistentCollectionChangeWorkUnitId(Serializable ownerId, String role) {
            this.ownerId = ownerId;
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersistentCollectionChangeWorkUnitId that = (PersistentCollectionChangeWorkUnitId)o;
            if (this.ownerId != null ? !this.ownerId.equals(that.ownerId) : that.ownerId != null) {
                return false;
            }
            return !(this.role != null ? !this.role.equals(that.role) : that.role != null);
        }

        public int hashCode() {
            int result = this.ownerId != null ? this.ownerId.hashCode() : 0;
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}

