/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query;

import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.impl.EntitiesAtRevisionQuery;
import org.hibernate.envers.query.impl.RevisionsOfEntityQuery;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.ArgumentsTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditQueryCreator {
    private final AuditConfiguration auditCfg;
    private final AuditReaderImplementor auditReaderImplementor;

    public AuditQueryCreator(AuditConfiguration auditCfg, AuditReaderImplementor auditReaderImplementor) {
        this.auditCfg = auditCfg;
        this.auditReaderImplementor = auditReaderImplementor;
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        return new EntitiesAtRevisionQuery(this.auditCfg, this.auditReaderImplementor, c, revision);
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, String entityName, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        return new EntitiesAtRevisionQuery(this.auditCfg, this.auditReaderImplementor, c, entityName, revision);
    }

    public AuditQuery forRevisionsOfEntity(Class<?> c, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        return new RevisionsOfEntityQuery(this.auditCfg, this.auditReaderImplementor, c, selectEntitiesOnly, selectDeletedEntities);
    }

    public AuditQuery forRevisionsOfEntity(Class<?> c, String entityName, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        return new RevisionsOfEntityQuery(this.auditCfg, this.auditReaderImplementor, c, entityName, selectEntitiesOnly, selectDeletedEntities);
    }
}

