/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.phonegap.AuthenticationToken;
import com.phonegap.DroidGap;
import com.phonegap.api.LOG;

public class CordovaWebViewClient
extends WebViewClient {
    private static final String TAG = "Cordova";
    DroidGap ctx;
    private boolean doClearHistory = false;

    public CordovaWebViewClient(DroidGap ctx) {
        this.ctx = ctx;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (!this.ctx.pluginManager.onOverrideUrlLoading(url)) {
            if (url.startsWith("tel:")) {
                try {
                    Intent intent = new Intent("android.intent.action.DIAL");
                    intent.setData(Uri.parse((String)url));
                    this.ctx.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error dialing " + url + ": " + e.toString());
                }
            } else if (url.startsWith("geo:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.ctx.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error showing map " + url + ": " + e.toString());
                }
            } else if (url.startsWith("mailto:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.ctx.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error sending email " + url + ": " + e.toString());
                }
            } else if (url.startsWith("sms:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    String address = null;
                    int parmIndex = url.indexOf(63);
                    if (parmIndex == -1) {
                        address = url.substring(4);
                    } else {
                        address = url.substring(4, parmIndex);
                        Uri uri = Uri.parse((String)url);
                        String query = uri.getQuery();
                        if (query != null && query.startsWith("body=")) {
                            intent.putExtra("sms_body", query.substring(5));
                        }
                    }
                    intent.setData(Uri.parse((String)("sms:" + address)));
                    intent.putExtra("address", address);
                    intent.setType("vnd.android-dir/mms-sms");
                    this.ctx.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error sending sms " + url + ":" + e.toString());
                }
            } else if (url.startsWith("file://") || url.indexOf(this.ctx.baseUrl) == 0 || this.ctx.isUrlWhiteListed(url)) {
                this.ctx.loadUrl(url);
            } else {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.ctx.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error loading url " + url, e);
                }
            }
        }
        return true;
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        AuthenticationToken token = this.ctx.getAuthenticationToken(host, realm);
        if (token != null) {
            handler.proceed(token.getUserName(), token.getPassword());
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        view.clearHistory();
        this.doClearHistory = true;
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (this.doClearHistory) {
            view.clearHistory();
            this.doClearHistory = false;
        }
        ++this.ctx.loadUrlTimeout;
        if (!url.equals("about:blank")) {
            this.ctx.appView.loadUrl("javascript:try{ PhoneGap.onNativeReady.fire();}catch(e){_nativeReady = true;}");
        }
        if (this.ctx.appView.getVisibility() == 4) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                        CordovaWebViewClient.this.ctx.runOnUiThread(new Runnable(){

                            public void run() {
                                CordovaWebViewClient.this.ctx.appView.setVisibility(0);
                                CordovaWebViewClient.this.ctx.spinnerStop();
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t.start();
        }
        if (url.equals("about:blank")) {
            if (this.ctx.callbackServer != null) {
                this.ctx.callbackServer.destroy();
            }
            this.ctx.endActivity();
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        LOG.d(TAG, "DroidGap: GapViewClient.onReceivedError: Error code=%s Description=%s URL=%s", errorCode, description, failingUrl);
        ++this.ctx.loadUrlTimeout;
        this.ctx.spinnerStop();
        this.ctx.onReceivedError(errorCode, description, failingUrl);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String packageName = this.ctx.getPackageName();
        PackageManager pm = this.ctx.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 128);
            if ((appInfo.flags & 2) != 0) {
                handler.proceed();
                return;
            }
            super.onReceivedSslError(view, handler, error);
        }
        catch (PackageManager.NameNotFoundException e) {
            super.onReceivedSslError(view, handler, error);
        }
    }
}

