// File: jc2_alt.v
// Generated by MyHDL 0.7dev
// Date: Thu Sep 30 16:28:28 2010


`timescale 1ns/10ps

module jc2_alt (
    goLeft,
    goRight,
    stop,
    clk,
    q
);
// A bi-directional 4-bit Johnson counter with stop control.
// 
// I/O pins:
// --------
// clk      : input free-running slow clock 
// goLeft   : input signal to shift left (active-low switch)
// goRight  : input signal to shift right (active-low switch)
// stop     : input signal to stop counting (active-low switch)
// q        : 4-bit counter output (active-low LEDs; q[0] is right-most)
// 
// Operation:
// ---------
// The counter is triggered on the rising edge of the clock (clk). 
// A low pulse on the goLeft input will cause the counter to start 
// shifting left from its current state. A low pulse on the goRight
// input will cause the counter to start shifting right from its 
// current state. A low pulse on the stop input will cause the 
// counter to hold its current state until goLeft or goRight is pulsed.
// 
// After power-up, the counter is stopped with all outputs low (LEDs lit).

input goLeft;
input goRight;
input stop;
input clk;
output [3:0] q;
reg [3:0] q;






always @(posedge clk) begin: JC2_ALT_LOGIC
    reg run;
    reg [1-1:0] dir;
    if ((goRight == 0)) begin
        dir = 1'b0;
        run = 1'b1;
    end
    else if ((goLeft == 0)) begin
        dir = 1'b1;
        run = 1'b1;
    end
    if ((stop == 0)) begin
        run = 1'b0;
    end
    if (run) begin
        if ((dir == 1'b1)) begin
            q[4-1:1] <= q[3-1:0];
            q[0] <= (!q[3]);
        end
        else begin
            q[3-1:0] <= q[4-1:1];
            q[3] <= (!q[0]);
        end
    end
end

endmodule
