/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.text.Collator;
import java.util.Locale;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.DbObject;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Mode;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Schema;
import org.h2.engine.Sequence;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.ObjectArray;
import org.h2.util.Resources;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class MetaTable
extends Table {
    public static final int TABLES = 0;
    public static final int COLUMNS = 1;
    public static final int INDEXES = 2;
    public static final int TABLE_TYPES = 3;
    public static final int TYPE_INFO = 4;
    public static final int CATALOGS = 5;
    public static final int SETTINGS = 6;
    public static final int HELP = 7;
    public static final int SEQUENCES = 8;
    public static final int USERS = 9;
    public static final int ROLES = 10;
    public static final int RIGHTS = 11;
    public static final int FUNCTION_ALIASES = 12;
    public static final int SCHEMATA = 13;
    public static final int TABLE_PRIVILEGES = 14;
    public static final int COLUMN_PRIVILEGES = 15;
    public static final int COLLATIONS = 16;
    public static final int VIEWS = 17;
    public static final int IN_DOUBT = 18;
    public static final int CROSS_REFERENCES = 19;
    public static final int CONSTRAINTS = 20;
    private int type;

    /*
     * WARNING - void declaration
     */
    public MetaTable(Schema schema, int type) throws SQLException {
        super(schema, 0, null, true);
        void var3_3;
        this.type = type;
        switch (type) {
            case 0: {
                this.setObjectName("TABLES");
                Column[] cols = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL"});
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                Column[] cols = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE SMALLINT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE SMALLINT", "IS_COMPUTED BIT", "SELECTIVITY INT"});
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                Column[] cols = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION INT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY", "INDEX_TYPE"});
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                Column[] cols = this.createColumns(new String[]{"TYPE"});
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                Column[] cols = this.createColumns(new String[]{"TYPE_NAME", "DATA_TYPE SMALLINT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT"});
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                Column[] cols = this.createColumns(new String[]{"CATALOG_NAME"});
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                Column[] cols = this.createColumns(new String[]{"NAME", "VALUE"});
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                Column[] cols = this.createColumns(new String[]{"ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT", "EXAMPLE"});
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                Column[] cols = this.createColumns(new String[]{"NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT"});
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                Column[] cols = this.createColumns(new String[]{"NAME", "ADMIN"});
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                Column[] cols = this.createColumns(new String[]{"NAME"});
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                Column[] cols = this.createColumns(new String[]{"GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME"});
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                Column[] cols = this.createColumns(new String[]{"ALIAS", "JAVA_CLASS", "JAVA_METHOD", "TYPE"});
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                Column[] cols = this.createColumns(new String[]{"CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT"});
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                Column[] cols = this.createColumns(new String[]{"GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE"});
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                Column[] cols = this.createColumns(new String[]{"GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE"});
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                Column[] cols = this.createColumns(new String[]{"NAME", "KEY"});
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                Column[] cols = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS"});
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                Column[] cols = this.createColumns(new String[]{"TRANSACTION", "STATE"});
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                Column[] cols = this.createColumns(new String[]{"PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION INT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME"});
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                Column[] cols = this.createColumns(new String[]{"CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "SQL"});
                break;
            }
            default: {
                throw Message.internal("type=" + type);
            }
        }
        this.setColumns((Column[])var3_3);
    }

    private Column[] createColumns(String[] names) {
        Column[] cols = new Column[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name;
            int type;
            String nameType = names[i];
            int idx = nameType.indexOf(32);
            if (idx < 0) {
                type = 13;
                name = nameType;
            } else {
                type = DataType.getTypeByName((String)nameType.substring((int)(idx + 1))).type;
                name = nameType.substring(0, idx);
            }
            cols[i] = new Column(name, type, 0L, 0);
        }
        return cols;
    }

    public String getCreateSQL() {
        return null;
    }

    public Index addIndex(Session session, String indexName, int indexId, Column[] cols, IndexType indexType, int headPos) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void lock(Session session, boolean exclusive) throws SQLException {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String s) {
        if (Mode.getCurrentMode().lowerCaseIdentifiers) {
            s = s == null ? s : s.toLowerCase();
        }
        return s;
    }

    public ObjectArray generateRows() throws SQLException {
        ObjectArray rows = new ObjectArray();
        String catalog = this.identifier(this.database.getShortName());
        switch (this.type) {
            case 0: {
                ObjectArray tables = this.database.getAllSchemaObjects(0);
                for (int i = 0; i < tables.size(); ++i) {
                    Table table = (Table)tables.get(i);
                    String storageType = table.getTemporary() ? "TEMPORARY" : (table.isPersistent() ? "CACHED" : "MEMORY");
                    this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), table.getTableType(), storageType, table.getCreateSQL()});
                }
                break;
            }
            case 1: {
                ObjectArray tables = this.database.getAllSchemaObjects(0);
                for (int i = 0; i < tables.size(); ++i) {
                    Table table = (Table)tables.get(i);
                    Column[] cols = table.getColumns();
                    String collation = this.database.getCompareMode().getName();
                    for (int j = 0; j < cols.length; ++j) {
                        Column c = cols[j];
                        this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(c.getName()), String.valueOf(j + 1), c.getDefaultExpression() == null ? "" : c.getDefaultExpression().getSQL(), c.isNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(c.getType()), "" + c.getPrecision(), "" + c.getPrecision(), "" + c.getPrecision(), "10", "" + c.getScale(), "Unicode", collation, this.identifier(DataType.getTypeName(c.getType())), "" + (c.isNullable() ? 1 : 0), "" + (c.getComputed() ? "TRUE" : "FALSE"), "" + c.getSelectivity()});
                    }
                }
                break;
            }
            case 2: {
                ObjectArray tables = this.database.getAllSchemaObjects(0);
                for (int i = 0; i < tables.size(); ++i) {
                    Table table = (Table)tables.get(i);
                    ObjectArray idx = table.getIndexes();
                    for (int j = 0; idx != null && j < idx.size(); ++j) {
                        Index index = (Index)idx.get(j);
                        if (index.getCreateSQL() == null) continue;
                        Column[] cols = index.getColumns();
                        for (int k = 0; k < cols.length; ++k) {
                            Column column = cols[k];
                            this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), index.getIndexType().isUnique() ? "FALSE" : "TRUE", this.identifier(index.getName()), "" + (k + 1), this.identifier(column.getName()), "0", index.getIndexType().isPrimaryKey() ? "TRUE" : "FALSE", index.getIndexType().getSQL()});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(rows, new String[]{"TABLE"});
                this.add(rows, new String[]{"VIEW"});
                break;
            }
            case 5: {
                this.add(rows, new String[]{catalog});
                break;
            }
            case 6: {
                ObjectArray list = this.database.getAllSettings();
                for (int i = 0; i < list.size(); ++i) {
                    Setting s = (Setting)list.get(i);
                    String value = s.getStringValue();
                    if (value == null) {
                        value = "" + s.getIntValue();
                    }
                    this.add(rows, new String[]{this.identifier(s.getName()), value});
                }
                this.add(rows, new String[]{"MODE", Mode.getCurrentMode().getName()});
                break;
            }
            case 4: {
                ObjectArray types = DataType.getTypes();
                for (int i = 0; i < types.size(); ++i) {
                    DataType t = (DataType)types.get(i);
                    if (t.hidden || t.sqlType == 0) continue;
                    this.add(rows, new String[]{t.name, String.valueOf(t.sqlType), String.valueOf(t.maxPrecision), t.prefix, t.suffix, t.params, String.valueOf(t.autoInc), String.valueOf(t.minScale), String.valueOf(t.maxScale), t.decimal ? "10" : null, String.valueOf(t.order), String.valueOf(t.caseSensitive)});
                }
                break;
            }
            case 7: {
                try {
                    String s;
                    byte[] data = Resources.get("/org/h2/res/help.txt");
                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
                    int i = 0;
                    String section = "";
                    while ((s = reader.readLine()) != null) {
                        String more;
                        if ((s = s.trim()).startsWith("[*") && s.endsWith("*]")) {
                            section = s.substring(2, s.length() - 2).trim();
                            continue;
                        }
                        if (s.length() == 0) continue;
                        String topic = s;
                        String line = reader.readLine().trim();
                        while ((more = reader.readLine()) != null && more.trim().length() != 0) {
                            line = line + "\n" + more.trim();
                        }
                        int idx1 = line.indexOf(35);
                        int idx2 = line.indexOf(35, idx1 + 1);
                        String syntax = "";
                        String example = "";
                        if (idx1 < 0 || idx2 < 0) {
                            throw Message.internal("help line error: " + line);
                        }
                        syntax = line.substring(0, idx1).trim();
                        String text = line.substring(idx1 + 1, idx2).trim();
                        example = line.substring(idx2 + 1).trim();
                        this.add(rows, new String[]{String.valueOf(i++), section, topic, syntax, text, example});
                    }
                    break;
                }
                catch (IOException e) {
                    throw Message.convert(e);
                }
            }
            case 8: {
                ObjectArray sequences = this.database.getAllSchemaObjects(3);
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence s = (Sequence)sequences.get(i);
                    this.add(rows, new String[]{this.identifier(s.getName()), String.valueOf(s.getCurrentValue()), String.valueOf(s.getIncrement())});
                }
                break;
            }
            case 9: {
                ObjectArray users = this.database.getAllUsers();
                for (int i = 0; i < users.size(); ++i) {
                    User u = (User)users.get(i);
                    this.add(rows, new String[]{this.identifier(u.getName()), String.valueOf(u.getAdmin())});
                }
                break;
            }
            case 10: {
                ObjectArray roles = this.database.getAllRoles();
                for (int i = 0; i < roles.size(); ++i) {
                    Role r = (Role)roles.get(i);
                    this.add(rows, new String[]{this.identifier(r.getName())});
                }
                break;
            }
            case 11: {
                ObjectArray rights = this.database.getAllRights();
                for (int i = 0; i < rights.size(); ++i) {
                    String type;
                    Right r = (Right)rights.get(i);
                    Role role = r.getGrantedRole();
                    DbObject grantee = r.getGrantee();
                    String string = type = grantee.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        Table granted = r.getGrantedTable();
                        this.add(rows, new String[]{this.identifier(grantee.getName()), type, "", r.getRights(), this.identifier(granted.getSchema().getName()), this.identifier(granted.getName())});
                        continue;
                    }
                    this.add(rows, new String[]{this.identifier(grantee.getName()), type, this.identifier(role.getName()), "", "", ""});
                }
                break;
            }
            case 12: {
                ObjectArray aliases = this.database.getAllFunctionAliases();
                for (int i = 0; i < aliases.size(); ++i) {
                    FunctionAlias alias = (FunctionAlias)aliases.get(i);
                    this.add(rows, new String[]{this.identifier(alias.getName()), alias.getJavaClassName(), alias.getJavaMethodName(), "" + alias.getDataType()});
                }
                break;
            }
            case 13: {
                ObjectArray schemas = this.database.getAllSchemas();
                String collation = this.database.getCompareMode().getName();
                for (int i = 0; i < schemas.size(); ++i) {
                    Schema schema = (Schema)schemas.get(i);
                    this.add(rows, new String[]{catalog, this.identifier(schema.getName()), this.identifier(schema.getOwner().getName()), "Unicode", collation, "PUBLIC".equals(schema.getName()) ? "TRUE" : "FALSE"});
                }
                break;
            }
            case 14: {
                ObjectArray rights = this.database.getAllRights();
                for (int i = 0; i < rights.size(); ++i) {
                    Right r = (Right)rights.get(i);
                    Table table = r.getGrantedTable();
                    if (table == null) continue;
                    this.addPrivileges(rows, r.getGrantee(), catalog, table, null, r.getRightMask());
                }
                break;
            }
            case 15: {
                ObjectArray rights = this.database.getAllRights();
                for (int i = 0; i < rights.size(); ++i) {
                    Right r = (Right)rights.get(i);
                    Table table = r.getGrantedTable();
                    if (table == null) continue;
                    DbObject grantee = r.getGrantee();
                    int mask = r.getRightMask();
                    Column[] columns = table.getColumns();
                    for (int j = 0; j < columns.length; ++j) {
                        String column = columns[j].getName();
                        this.addPrivileges(rows, grantee, catalog, table, column, mask);
                    }
                }
                break;
            }
            case 16: {
                Locale[] locales = Collator.getAvailableLocales();
                for (int i = 0; i < locales.length; ++i) {
                    Locale l = locales[i];
                    this.add(rows, new String[]{CompareMode.getName(l), l.toString()});
                }
                break;
            }
            case 17: {
                ObjectArray tables = this.database.getAllSchemaObjects(0);
                for (int i = 0; i < tables.size(); ++i) {
                    Table table = (Table)tables.get(i);
                    if (!table.getTableType().equals("VIEW")) continue;
                    TableView view = (TableView)table;
                    this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), table.getCreateSQL(), "NONE", "NO", view.getInvalid() ? "INVALID" : "VALID"});
                }
                break;
            }
            case 18: {
                ObjectArray prepared = this.database.getLog().getInDoubtTransactions();
                for (int i = 0; prepared != null && i < prepared.size(); ++i) {
                    InDoubtTransaction prep = (InDoubtTransaction)prepared.get(i);
                    this.add(rows, new String[]{prep.getTransaction(), prep.getState()});
                }
                break;
            }
            case 19: {
                ObjectArray constraints = this.database.getAllSchemaObjects(5);
                for (int i = 0; i < constraints.size(); ++i) {
                    Constraint constraint = (Constraint)constraints.get(i);
                    if (!constraint.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential ref = (ConstraintReferential)constraint;
                    Column[] cols = ref.getColumns();
                    Column[] refCols = ref.getRefColumns();
                    Table tab = ref.getTable();
                    Table refTab = ref.getRefTable();
                    int upd = this.getRefAction(ref.getUpdateAction());
                    int del = this.getRefAction(ref.getDeleteAction());
                    for (int j = 0; j < cols.length; ++j) {
                        this.add(rows, new String[]{catalog, this.identifier(refTab.getSchema().getName()), this.identifier(refTab.getName()), this.identifier(refCols[j].getName()), catalog, this.identifier(tab.getSchema().getName()), this.identifier(tab.getName()), this.identifier(cols[j].getName()), String.valueOf(j + 1), String.valueOf(upd), String.valueOf(del), this.identifier(ref.getName()), null});
                    }
                }
                break;
            }
            case 20: {
                ObjectArray constraints = this.database.getAllSchemaObjects(5);
                for (int i = 0; i < constraints.size(); ++i) {
                    Constraint constraint = (Constraint)constraints.get(i);
                    String type = constraint.getConstraintType();
                    String checkExpression = null;
                    Column[] columns = null;
                    Table table = constraint.getTable();
                    if (type.equals("CHECK")) {
                        checkExpression = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (type.equals("UNIQUE")) {
                        columns = ((ConstraintUnique)constraint).getColumns();
                    } else if (type.equals("REFERENTIAL")) {
                        columns = ((ConstraintReferential)constraint).getColumns();
                    }
                    String columnList = null;
                    if (columns != null) {
                        columnList = "";
                        for (int j = 0; j < columns.length; ++j) {
                            if (j > 0) {
                                columnList = columnList + ",";
                            }
                            columnList = columnList + columns[j].getName();
                        }
                    }
                    this.add(rows, new String[]{catalog, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), type, catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), checkExpression, columnList, constraint.getCreateSQL()});
                }
                break;
            }
            default: {
                throw Message.internal("type=" + this.type);
            }
        }
        return rows;
    }

    private int getRefAction(int action) {
        switch (action) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw Message.internal("action=" + action);
    }

    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeIndex(String indexName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void close(Session session) throws SQLException {
    }

    public void unlock(Session s) {
    }

    private void addPrivileges(ObjectArray rows, DbObject grantee, String catalog, Table table, String column, int rightMask) throws SQLException {
        if ((rightMask & 1) != 0) {
            this.addPrivileg(rows, grantee, catalog, table, column, "SELECT");
        }
        if ((rightMask & 4) != 0) {
            this.addPrivileg(rows, grantee, catalog, table, column, "INSERT");
        }
        if ((rightMask & 8) != 0) {
            this.addPrivileg(rows, grantee, catalog, table, column, "UPDATE");
        }
        if ((rightMask & 2) != 0) {
            this.addPrivileg(rows, grantee, catalog, table, column, "DELETE");
        }
    }

    private void addPrivileg(ObjectArray rows, DbObject grantee, String catalog, Table table, String column, String right) throws SQLException {
        User user;
        String isGrantable = "NO";
        if (grantee.getType() == 2 && (user = (User)grantee).getAdmin()) {
            isGrantable = "YES";
        }
        if (column == null) {
            this.add(rows, new String[]{null, this.identifier(grantee.getName()), catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), right, isGrantable});
        } else {
            this.add(rows, new String[]{null, this.identifier(grantee.getName()), catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(column), right, isGrantable});
        }
    }

    private void add(ObjectArray rows, String[] strings) throws SQLException {
        Value[] values = new Value[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String s = strings[i];
            Value v = s == null ? ValueNull.INSTANCE : ValueString.get(s);
            Column col = this.columns[i];
            values[i] = v = v.convertTo(col.getType());
        }
        Row row = new Row(values);
        row.setPos(rows.size());
        rows.add(row);
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public int getRowCount() {
        throw Message.internal();
    }

    public boolean canGetRowCount() {
        return false;
    }

    public String getTableType() {
        return "SYSTEM TABLE";
    }

    public Index getScanIndex(Session session) throws SQLException {
        return new MetaIndex(this, this.columns);
    }

    public ObjectArray getIndexes() {
        return null;
    }
}

