/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class Role
extends RightOwner {
    private boolean system;

    public Role(Database database, int id, String roleName, boolean system) {
        super(database, id, roleName, "user");
        this.system = system;
    }

    public String getCreateSQLForCopy(Table table, String quotedTable, String quotedName) {
        throw Message.internal();
    }

    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        return "CREATE ROLE " + this.getSQL();
    }

    public int getType() {
        return 7;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        Right right;
        ObjectArray users = this.database.getAllUsers();
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            Right right2 = user.getRightForRole(this);
            if (right2 == null) continue;
            this.database.removeDatabaseObject(session, right2);
        }
        ObjectArray roles = this.database.getAllRoles();
        for (int i = 0; i < roles.size(); ++i) {
            Role r2 = (Role)roles.get(i);
            right = r2.getRightForRole(this);
            if (right == null) continue;
            this.database.removeDatabaseObject(session, right);
        }
        ObjectArray rights = this.database.getAllRights();
        for (int i = 0; i < rights.size(); ++i) {
            right = (Right)rights.get(i);
            if (right.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.invalidate();
    }

    public void checkRename() throws SQLException {
    }
}

