/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.ObjectArray;

public class CreateView
extends SchemaCommand {
    private Query select;
    private String viewName;
    private boolean ifNotExists;
    private boolean force;
    private String selectSQL;

    public CreateView(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setViewName(String name) {
        this.viewName = name;
    }

    public void setSelect(Query select) {
        this.select = select;
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        if (this.getSchema().findTableOrView(this.session, this.viewName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90038, this.viewName);
        }
        int id = this.getObjectId(true, true);
        String querySQL = this.select == null && this.force ? this.selectSQL : this.select.getSQL();
        TableView view = new TableView(this.getSchema(), id, this.viewName, querySQL, null, this.session);
        db.addSchemaObject(this.session, view);
        ObjectArray tables = view.getTables();
        for (int i = 0; i < tables.size(); ++i) {
            Table t = (Table)tables.get(i);
            t.addView(view);
        }
        return 0;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setSelectSQL(String selectSQL) {
        this.selectSQL = selectSQL;
    }
}

