/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.zip;

public final class ZipShort
implements Cloneable {
    private int m_value;

    public ZipShort(int value) {
        this.m_value = value;
    }

    public ZipShort(byte[] bytes) {
        this(bytes, 0);
    }

    public ZipShort(byte[] bytes, int offset) {
        this.m_value = bytes[offset + 1] << 8 & 0xFF00;
        this.m_value += bytes[offset] & 0xFF;
    }

    public byte[] getBytes() {
        byte[] result = new byte[]{(byte)(this.m_value & 0xFF), (byte)((this.m_value & 0xFF00) >> 8)};
        return result;
    }

    public int getValue() {
        return this.m_value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ZipShort)) {
            return false;
        }
        return this.m_value == ((ZipShort)o).getValue();
    }

    public int hashCode() {
        return this.m_value;
    }
}

