/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;

public final class Element
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3343087714201120157L;
    private static final Logger LOG = Logger.getLogger(Element.class.getName());
    private static final long ONE_SECOND = 1000L;
    private final Object key;
    private Object value;
    private long version;
    private long creationTime;
    private long lastAccessTime;
    private long nextToLastAccessTime;
    private long hitCount;
    private int timeToLive;
    private int timeToIdle;
    private long lastUpdateTime;
    private boolean eternal;
    private boolean lifespanSet;

    public Element(Serializable key, Serializable value, long version) {
        this((Object)key, (Object)value, version);
    }

    public Element(Object key, Object value, long version) {
        this.key = key;
        this.value = value;
        this.version = version;
        this.creationTime = System.currentTimeMillis();
        this.hitCount = 0L;
    }

    public Element(Object key, Object value, long version, long creationTime, long lastAccessTime, long nextToLastAccessTime, long lastUpdateTime, long hitCount) {
        this.key = key;
        this.value = value;
        this.version = version;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.nextToLastAccessTime = nextToLastAccessTime;
        this.lastUpdateTime = lastUpdateTime;
        this.hitCount = hitCount;
    }

    public Element(Object key, Object value, Boolean eternal, Integer timeToIdleSeconds, Integer timeToLiveSeconds) {
        this.key = key;
        this.value = value;
        if (eternal != null) {
            this.setEternal(eternal);
        }
        if (timeToIdleSeconds != null) {
            this.setTimeToIdle(timeToIdleSeconds);
        }
        if (timeToLiveSeconds != null) {
            this.setTimeToLive(timeToLiveSeconds);
        }
        this.creationTime = System.currentTimeMillis();
    }

    public Element(Serializable key, Serializable value) {
        this((Object)key, (Object)value, 1L);
    }

    public Element(Object key, Object value) {
        this(key, value, 1L);
    }

    public final Serializable getKey() {
        Serializable keyAsSerializable;
        try {
            keyAsSerializable = (Serializable)this.key;
        }
        catch (Exception e) {
            throw new CacheException("The key " + this.key + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return keyAsSerializable;
    }

    public final Object getObjectKey() {
        return this.key;
    }

    public final Serializable getValue() {
        Serializable valueAsSerializable;
        try {
            valueAsSerializable = (Serializable)this.value;
        }
        catch (Exception e) {
            throw new CacheException("The value " + this.value + " for key " + this.key + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return valueAsSerializable;
    }

    public final Object getObjectValue() {
        return this.value;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Element)) {
            return false;
        }
        Element element = (Element)object;
        if (this.key == null || element.getObjectKey() == null) {
            return false;
        }
        return this.key.equals(element.getObjectKey());
    }

    public void setTimeToLive(int timeToLiveSeconds) {
        this.timeToLive = timeToLiveSeconds;
        this.lifespanSet = true;
    }

    public void setTimeToIdle(int timeToIdleSeconds) {
        this.timeToIdle = timeToIdleSeconds;
        this.lifespanSet = true;
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public final void setVersion(long version) {
        this.version = version;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final void setCreateTime() {
        this.creationTime = System.currentTimeMillis();
    }

    public final long getVersion() {
        return this.version;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final long getNextToLastAccessTime() {
        return this.nextToLastAccessTime;
    }

    public final long getHitCount() {
        return this.hitCount;
    }

    public final void resetAccessStatistics() {
        this.lastAccessTime = 0L;
        this.nextToLastAccessTime = 0L;
        this.hitCount = 0L;
    }

    public final void updateAccessStatistics() {
        this.nextToLastAccessTime = this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        ++this.hitCount;
    }

    public final void updateUpdateStatistics() {
        this.version = this.lastUpdateTime = System.currentTimeMillis();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ key = ").append(this.key).append(", value=").append(this.value).append(", version=").append(this.version).append(", hitCount=").append(this.hitCount).append(", CreationTime = ").append(this.getCreationTime()).append(", LastAccessTime = ").append(this.getLastAccessTime()).append(" ]");
        return sb.toString();
    }

    public final Object clone() throws CloneNotSupportedException {
        super.clone();
        Element element = new Element(this.deepCopy(this.key), this.deepCopy(this.value), this.version);
        element.creationTime = this.creationTime;
        element.lastAccessTime = this.lastAccessTime;
        element.nextToLastAccessTime = this.nextToLastAccessTime;
        element.hitCount = this.hitCount;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deepCopy(Object oldValue) {
        Serializable newValue = null;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(oldValue);
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ois = new ObjectInputStream(bin);
            newValue = (Serializable)ois.readObject();
        }
        catch (IOException e) {
            LOG.severe("Error cloning Element with key " + this.key + " during serialization and deserialization of value");
        }
        catch (ClassNotFoundException e) {
            LOG.severe("Error cloning Element with key " + this.key + " during serialization and deserialization of value");
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {
                LOG.severe("Error closing Stream");
            }
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSerializedSize() {
        if (!this.isSerializable()) {
            return 0L;
        }
        long size = 0L;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(this);
            long l = size = (long)bout.size();
            return l;
        }
        catch (IOException e) {
            LOG.fine("Error measuring element size for element with key " + this.key + ". Cause was: " + e.getMessage());
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                LOG.severe("Error closing ObjectOutputStream");
            }
        }
        return size;
    }

    public final boolean isSerializable() {
        return this.key instanceof Serializable && this.value instanceof Serializable;
    }

    public final boolean isKeySerializable() {
        return this.key instanceof Serializable;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public boolean isExpired() {
        long expirationTime;
        if (!this.lifespanSet) {
            return false;
        }
        long now = System.currentTimeMillis();
        return now > (expirationTime = this.getExpirationTime());
    }

    public long getExpirationTime() {
        if (!this.lifespanSet || this.eternal || this.timeToLive == 0 && this.timeToIdle == 0) {
            return Long.MAX_VALUE;
        }
        long expirationTime = 0L;
        long ttlExpiry = this.creationTime + (long)this.timeToLive * 1000L;
        long mostRecentTime = Math.max(this.creationTime, this.nextToLastAccessTime);
        long ttiExpiry = mostRecentTime + (long)this.timeToIdle * 1000L;
        expirationTime = this.timeToLive != 0 && (this.timeToIdle == 0 || this.lastAccessTime == 0L) ? ttlExpiry : (this.timeToLive == 0 ? ttiExpiry : Math.min(ttlExpiry, ttiExpiry));
        return expirationTime;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
        this.lifespanSet = true;
    }

    public boolean isLifespanSet() {
        return this.lifespanSet;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public int getTimeToIdle() {
        return this.timeToIdle;
    }
}

