/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.python.pydev.core.cache.Cache;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<Key, Val>
implements Cache<Key, Val>,
Serializable {
    protected int maxSize;
    private static final long serialVersionUID = 1L;
    private transient int removeEntries;
    private transient int initialMaxSize;
    protected LinkedHashMap<Key, Val> cache;

    public LRUCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = this.createMap(maxSize);
    }

    protected LinkedHashMap<Key, Val> createMap(int maxSize) {
        return new LinkedHashMap<Key, Val>(maxSize + 1, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.maxSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGrowAsNeeded() {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            --this.removeEntries;
            if (this.removeEntries == 0) {
                this.maxSize = this.initialMaxSize;
                Iterator<Map.Entry<Key, Val>> iter = this.cache.entrySet().iterator();
                int i = 0;
                while (i < this.cache.size() - this.maxSize) {
                    iter.next();
                    ++i;
                }
                while (this.cache.size() > this.maxSize && iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGrowAsNeeded(int newSize) {
        if (this.removeEntries > 0) {
            throw new RuntimeException("There is alrdeady a new size in action. This class should be synched for this access.");
        }
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            ++this.removeEntries;
            if (this.removeEntries == 1) {
                this.initialMaxSize = this.maxSize;
                this.maxSize = newSize;
            }
        }
    }

    @Override
    public Val getObj(Key key) {
        return this.cache.get(key);
    }

    @Override
    public void remove(Key key) {
        this.cache.remove(key);
    }

    @Override
    public void add(Key key, Val val) {
        this.cache.put(key, val);
    }

    public void clear() {
        this.cache.clear();
    }
}

