/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PyInformationPresenter;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.hover.IPyHoverParticipant;
import org.python.pydev.editor.hover.PyHoverPreferencesPage;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.plugin.PydevPlugin;

public class PyTextHover
implements ITextHover,
ITextHoverExtension {
    private boolean pythonCommentOrMultiline = false;
    private FastStringBuffer buf = new FastStringBuffer();
    private ITextSelection textSelection;

    public PyTextHover(ISourceViewer sourceViewer, String contentType) {
        String[] stringArray = IPythonPartitions.types;
        int n = IPythonPartitions.types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(contentType)) {
                this.pythonCommentOrMultiline = true;
            }
            ++n2;
        }
    }

    public synchronized String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.buf.clear();
        if (!this.pythonCommentOrMultiline && textViewer instanceof PySourceViewer) {
            PySourceViewer s = (PySourceViewer)textViewer;
            PySelection ps = new PySelection(s.getDocument(), hoverRegion.getOffset() + hoverRegion.getLength());
            this.getMarkerHover(hoverRegion, s);
            if (PyHoverPreferencesPage.getShowDocstringOnHover()) {
                this.getDocstringHover(hoverRegion, s, ps);
            }
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_hover");
            Iterator iterator = participants.iterator();
            while (iterator.hasNext()) {
                IPyHoverParticipant pyHoverParticipant = (IPyHoverParticipant)iterator.next();
                try {
                    String hoverText = pyHoverParticipant.getHoverText(hoverRegion, s, ps, this.textSelection);
                    if (hoverText == null || hoverText.trim().length() <= 0) continue;
                    if (this.buf.length() > 0) {
                        this.buf.append(PyInformationPresenter.LINE_DELIM);
                    }
                    this.buf.append(hoverText);
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
        }
        return this.buf.toString();
    }

    private void getMarkerHover(IRegion hoverRegion, PySourceViewer s) {
        Iterator iterator = s.getMarkerIteratable().iterator();
        while (iterator.hasNext()) {
            IMarker marker = (IMarker)iterator.next();
            try {
                Integer cStart = (Integer)marker.getAttribute("charStart");
                Integer cEnd = (Integer)marker.getAttribute("charEnd");
                if (cStart == null || cEnd == null) continue;
                int offset = hoverRegion.getOffset();
                if (cStart > offset || cEnd < offset) continue;
                if (this.buf.length() > 0) {
                    this.buf.append(PyInformationPresenter.LINE_DELIM);
                }
                this.buf.appendObject(marker.getAttribute("message"));
            }
            catch (CoreException coreException) {}
        }
    }

    private void getDocstringHover(IRegion hoverRegion, PySourceViewer s, PySelection ps) {
        RefactoringRequest request;
        CompletionCache completionCache = new CompletionCache();
        ArrayList<IDefinition> selected = new ArrayList<IDefinition>();
        PyEdit edit = s.getEdit();
        try {
            request = new RefactoringRequest(edit.getEditorFile(), ps, (IProgressMonitor)new NullProgressMonitor(), edit.getPythonNature(), edit);
        }
        catch (MisconfigurationException misconfigurationException) {
            return;
        }
        String[] tokenAndQual = PyRefactoringFindDefinition.findActualDefinition(request, completionCache, selected);
        if (tokenAndQual != null && selected.size() > 0) {
            Iterator<IDefinition> iterator = selected.iterator();
            while (iterator.hasNext()) {
                IDefinition d = iterator.next();
                Definition def = (Definition)d;
                String docstring = d.getDocstring();
                if (this.buf.length() > 0 && (docstring != null || def.value != null || def.module != null)) {
                    this.buf.append(PyInformationPresenter.LINE_DELIM);
                }
                if (def.value != null) {
                    this.buf.append("<pydev_hint_bold>");
                    this.buf.append(def.value);
                    this.buf.append(' ');
                    this.buf.append("</pydev_hint_bold>");
                }
                if (def.module != null) {
                    this.buf.append("(");
                    this.buf.append("<pydev_hint_bold>");
                    this.buf.append(def.module.getName());
                    this.buf.append("</pydev_hint_bold>");
                    this.buf.append(")");
                    this.buf.append(PyInformationPresenter.LINE_DELIM);
                }
                if (docstring == null || docstring.trim().length() <= 0) continue;
                this.buf.append(StringUtils.removeWhitespaceColumnsToLeft((String)docstring));
            }
        }
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        this.textSelection = (ITextSelection)textViewer.getSelectionProvider().getSelection();
        return new Region(offset, 0);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                String tooltipAffordanceString = null;
                try {
                    tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
                }
                catch (Throwable throwable) {}
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new PyInformationPresenter(), tooltipAffordanceString);
            }
        };
    }
}

