/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.lvalues.DefaultDataTable;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.DefaultComparator;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.NumberSequence;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeConversionException;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnyNumberSequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnySequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.DefaultNumberSequence;
import org.pentaho.reporting.libraries.formula.util.DateUtil;
import org.pentaho.reporting.libraries.formula.util.HSSFDateUtil;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DefaultTypeRegistry
implements TypeRegistry {
    private static final Log logger = LogFactory.getLog(DefaultTypeRegistry.class);
    private static final BigDecimal NUM_TRUE = new BigDecimal("1");
    private static final BigDecimal NUM_FALSE;
    private static final BigDecimal ZERO;
    private FormulaContext context;
    private NumberFormat[] numberFormats;

    public ExtendedComparator getComparator(Type type1, Type type2) {
        DefaultComparator comparator = new DefaultComparator();
        comparator.inititalize(this.context);
        return comparator;
    }

    public Number convertToNumber(Type sourceType, Object value) throws EvaluationException {
        LocalizationContext localizationContext = this.context.getLocalizationContext();
        if (value == null) {
            throw TypeConversionException.getInstance();
        }
        boolean isAnyType = sourceType.isFlagSet("type.any");
        if (sourceType.isFlagSet("type.numeric") || isAnyType) {
            if ((sourceType.isFlagSet("type.datetime") || sourceType.isFlagSet("type.time") || sourceType.isFlagSet("type.date") || isAnyType) && value instanceof java.util.Date) {
                BigDecimal serial = HSSFDateUtil.getExcelDate((java.util.Date)value);
                return DateUtil.normalizeDate(serial, sourceType);
            }
            if (value instanceof Number) {
                return (Number)value;
            }
        }
        if ((sourceType.isFlagSet("type.logical") || isAnyType) && value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                return NUM_TRUE;
            }
            return NUM_FALSE;
        }
        if (sourceType.isFlagSet("type.text") || isAnyType) {
            String val = this.computeStringValue(value);
            try {
                return new BigDecimal(val);
            }
            catch (NumberFormatException e) {
                for (DateFormat df : localizationContext.getDateFormats(DateTimeType.DATETIME_TYPE)) {
                    java.util.Date date = DefaultTypeRegistry.parse(df, val);
                    if (date == null) continue;
                    return HSSFDateUtil.getExcelDate(date);
                }
                for (DateFormat df : localizationContext.getDateFormats(DateTimeType.DATE_TYPE)) {
                    java.util.Date date = DefaultTypeRegistry.parse(df, val);
                    if (date == null) continue;
                    return HSSFDateUtil.getExcelDate(date);
                }
                for (DateFormat df : localizationContext.getDateFormats(DateTimeType.TIME_TYPE)) {
                    java.util.Date date = DefaultTypeRegistry.parse(df, val);
                    if (date == null) continue;
                    return HSSFDateUtil.getExcelDate(date);
                }
                for (int i = 0; i < this.numberFormats.length; ++i) {
                    NumberFormat format = this.numberFormats[i];
                    Number number = DefaultTypeRegistry.parse(format, val);
                    if (number == null) continue;
                    return number;
                }
            }
        }
        throw TypeConversionException.getInstance();
    }

    private static Number parse(NumberFormat format, String source) {
        ParsePosition parsePosition = new ParsePosition(0);
        Number result = format.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0 || parsePosition.getIndex() != source.length()) {
            return null;
        }
        return result;
    }

    private static java.util.Date parse(DateFormat format, String source) {
        ParsePosition parsePosition = new ParsePosition(0);
        java.util.Date result = format.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0 || parsePosition.getIndex() != source.length()) {
            return null;
        }
        return result;
    }

    public void initialize(Configuration configuration, FormulaContext formulaContext) {
        this.initialize(formulaContext);
    }

    public void initialize(FormulaContext formulaContext) {
        if (formulaContext == null) {
            throw new NullPointerException();
        }
        this.context = formulaContext;
        this.numberFormats = this.loadNumberFormats();
    }

    protected NumberFormat[] loadNumberFormats() {
        ArrayList<DecimalFormat> formats = new ArrayList<DecimalFormat>();
        DecimalFormat defaultFormat = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
        this.activateBigDecimalMode(defaultFormat);
        formats.add(defaultFormat);
        return formats.toArray(new NumberFormat[formats.size()]);
    }

    private void activateBigDecimalMode(DecimalFormat format) {
        if (ObjectUtilities.isJDK14()) {
            try {
                Method method = DecimalFormat.class.getMethod("setParseBigDecimal", Boolean.TYPE);
                method.invoke((Object)format, Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String convertToText(Type type1, Object value) throws EvaluationException {
        if (value == null) {
            return "";
        }
        if (type1.isFlagSet("type.text")) {
            return this.computeStringValue(value);
        }
        if (type1.isFlagSet("type.logical")) {
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                if (Boolean.TRUE.equals(b)) {
                    return "TRUE";
                }
                return "FALSE";
            }
            throw TypeConversionException.getInstance();
        }
        if (type1.isFlagSet("type.numeric")) {
            if (type1.isFlagSet("type.datetime") || type1.isFlagSet("type.date") || type1.isFlagSet("type.time")) {
                java.util.Date d = this.convertToDate(type1, value);
                List dateFormats = this.context.getLocalizationContext().getDateFormats(type1);
                if (dateFormats != null && dateFormats.size() >= 1) {
                    DateFormat format = (DateFormat)dateFormats.get(0);
                    return format.format(d);
                }
                return DateFormat.getDateTimeInstance(0, 0).format(d);
            }
            try {
                Number n = this.convertToNumber(type1, value);
                NumberFormat format = this.getDefaultNumberFormat();
                return format.format(n);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return this.computeStringValue(value);
    }

    private String computeStringValue(Object retval) {
        if (retval instanceof Clob) {
            return IOUtils.getInstance().readClob((Clob)retval);
        }
        if (retval != null) {
            return retval.toString();
        }
        return null;
    }

    public Boolean convertToLogical(Type type1, Object value) throws TypeConversionException {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (type1.isFlagSet("type.logical") || type1.isFlagSet("type.any")) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if ("true".equalsIgnoreCase(String.valueOf(value))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (type1.isFlagSet("type.numeric")) {
            Number num;
            if (value instanceof Number && !ZERO.equals(num = (Number)value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (type1.isFlagSet("type.text")) {
            String str = this.computeStringValue(value);
            if ("TRUE".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("FALSE".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
        }
        throw TypeConversionException.getInstance();
    }

    public java.util.Date convertToDate(Type type1, Object value) throws EvaluationException {
        if ((type1.isFlagSet("type.numeric") || type1.isFlagSet("type.any")) && (type1.isFlagSet("type.date") || type1.isFlagSet("type.datetime") || type1.isFlagSet("type.time") || type1.isFlagSet("type.any")) && value instanceof java.util.Date) {
            return DateUtil.normalizeDate((java.util.Date)value, type1);
        }
        Number serial = this.convertToNumber(type1, value);
        BigDecimal bd = NumberUtil.getAsBigDecimal(serial);
        return HSSFDateUtil.getJavaDate(bd);
    }

    protected NumberFormat getDefaultNumberFormat() {
        Locale locale = this.context.getLocalizationContext().getLocale();
        return new DecimalFormat("#0.#########", new DecimalFormatSymbols(locale));
    }

    public ArrayCallback convertToArray(Type type, Object value) throws EvaluationException {
        if (value instanceof ArrayCallback) {
            return (ArrayCallback)value;
        }
        if (value == null) {
            return new DefaultDataTable().getAsArray();
        }
        Class<?> valueType = value.getClass();
        if (!valueType.isArray()) {
            if (value instanceof Collection) {
                Collection colVal = (Collection)value;
                DefaultDataTable table = new DefaultDataTable();
                Iterator iterator = colVal.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    table.setObject(i, 0, new StaticValue(iterator.next()));
                    ++i;
                }
                return table.getAsArray();
            }
            return new ArrayConverterCallback(value, type);
        }
        Class<?> componentType = valueType.getComponentType();
        if (componentType.isArray()) {
            DefaultDataTable table = new DefaultDataTable();
            int length = Array.getLength(value);
            for (int row = 0; row < length; ++row) {
                Object innerArray = Array.get(value, row);
                int innerLength = Array.getLength(innerArray);
                for (int col = 0; col < innerLength; ++col) {
                    table.setObject(row, col, new StaticValue(Array.get(innerArray, col)));
                }
            }
            return table.getAsArray();
        }
        DefaultDataTable table = new DefaultDataTable();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            table.setObject(i, 0, new StaticValue(Array.get(value, i)));
        }
        return table.getAsArray();
    }

    private TypeValuePair convertToSequence(Type targetType, TypeValuePair valuePair) throws EvaluationException {
        if (targetType.isFlagSet("type.numeric.sequence")) {
            return new TypeValuePair(targetType, this.convertToNumberSequence(valuePair.getType(), valuePair.getValue(), true));
        }
        return new TypeValuePair(targetType, this.convertToSequence(valuePair.getType(), valuePair.getValue()));
    }

    public Sequence convertToSequence(Type type, Object value) throws EvaluationException {
        if (type.isFlagSet("type.scalar")) {
            return new AnySequence(new StaticValue(value, type), this.context);
        }
        if (type.isFlagSet("type.sequence")) {
            if (value instanceof Sequence) {
                return (Sequence)value;
            }
            logger.warn((Object)"Assertation failure: Type declared to be a sequence, but no sequence found inside.");
            throw TypeConversionException.getInstance();
        }
        if (type.isFlagSet("type.array")) {
            if (value instanceof ArrayCallback) {
                return new AnySequence((ArrayCallback)value, this.context);
            }
            logger.warn((Object)"Assertation failure: Type declared to be array, but no array callback found inside.");
            throw TypeConversionException.getInstance();
        }
        throw TypeConversionException.getInstance();
    }

    public NumberSequence convertToNumberSequence(Type type, Object value, boolean strict) throws EvaluationException {
        if (type.isFlagSet("type.numeric.sequence")) {
            if (value instanceof DefaultNumberSequence) {
                return (NumberSequence)value;
            }
            return new DefaultNumberSequence(this.context);
        }
        if (type.isFlagSet("type.array")) {
            if (value instanceof ArrayCallback) {
                if (strict) {
                    return new DefaultNumberSequence((ArrayCallback)value, this.context);
                }
                return new AnyNumberSequence((ArrayCallback)value, this.context);
            }
            logger.warn((Object)"Assertation failure: Type declared to be array, but no array callback found inside.");
            throw TypeConversionException.getInstance();
        }
        if (type.isFlagSet("type.scalar") || type.isFlagSet("type.numeric")) {
            return new DefaultNumberSequence(new StaticValue((Object)this.convertToNumber(type, value), NumberType.GENERIC_NUMBER), this.context);
        }
        return new DefaultNumberSequence(this.context);
    }

    public TypeValuePair convertTo(Type targetType, TypeValuePair valuePair) throws EvaluationException {
        Object o;
        if (targetType.isFlagSet("type.array")) {
            if (valuePair.getType().isFlagSet("type.array")) {
                return valuePair;
            }
            if (targetType.isFlagSet("type.sequence")) {
                return this.convertTo(targetType, valuePair);
            }
            Object o2 = valuePair.getValue();
            if (o2 != null && o2.getClass().isArray()) {
                return new TypeValuePair(targetType, this.convertToArray(valuePair.getType(), o2));
            }
            Object retval = this.convertPlainToPlain(targetType, valuePair.getType(), valuePair.getValue());
            return new TypeValuePair(targetType, new ArrayConverterCallback(retval, targetType));
        }
        if (targetType.isFlagSet("type.sequence")) {
            if (valuePair.getType().isFlagSet("type.array")) {
                return this.convertToSequence(targetType, valuePair);
            }
            if (targetType.isFlagSet("type.sequence")) {
                return valuePair;
            }
            Object retval = this.convertPlainToPlain(targetType, valuePair.getType(), valuePair.getValue());
            ArrayConverterCallback converterCallback = new ArrayConverterCallback(retval, targetType);
            return this.convertToSequence(targetType, new TypeValuePair(AnyType.ANY_ARRAY, converterCallback));
        }
        Object value = valuePair.getValue();
        if (value == (o = this.convertPlainToPlain(targetType, valuePair.getType(), value))) {
            return valuePair;
        }
        return new TypeValuePair(targetType, o);
    }

    private Object convertPlainToPlain(Type targetType, Type sourceType, Object value) throws EvaluationException {
        if (targetType.isFlagSet("type.numeric")) {
            if (targetType.isFlagSet("type.logical")) {
                if (sourceType.isFlagSet("type.logical")) {
                    return value;
                }
                return this.convertToLogical(sourceType, value);
            }
            if (value instanceof java.util.Date && (targetType.isFlagSet("type.date") || targetType.isFlagSet("type.datetime") || targetType.isFlagSet("type.time"))) {
                java.util.Date toJavaDate = (java.util.Date)value;
                return DateUtil.normalizeDate(toJavaDate, targetType, false);
            }
            Number serial = this.convertToNumber(sourceType, value);
            if (targetType.isFlagSet("type.date") || targetType.isFlagSet("type.datetime") || targetType.isFlagSet("type.time")) {
                BigDecimal fromAsBigDecimal = NumberUtil.getAsBigDecimal(serial);
                BigDecimal normalizedSerial = DateUtil.normalizeDate(fromAsBigDecimal, targetType);
                java.util.Date toJavaDate = HSSFDateUtil.getJavaDate(normalizedSerial);
                return DateUtil.normalizeDate(toJavaDate, targetType, false);
            }
            return serial;
        }
        if (targetType.isFlagSet("type.text")) {
            return this.convertToText(sourceType, value);
        }
        return value;
    }

    public Type guessTypeOfObject(Object o) {
        if (o instanceof Number) {
            return NumberType.GENERIC_NUMBER;
        }
        if (o instanceof Time) {
            return DateTimeType.TIME_TYPE;
        }
        if (o instanceof Date) {
            return DateTimeType.DATE_TYPE;
        }
        if (o instanceof java.util.Date) {
            return DateTimeType.DATETIME_TYPE;
        }
        if (o instanceof Boolean) {
            return LogicalType.TYPE;
        }
        if (o instanceof String) {
            return TextType.TYPE;
        }
        return AnyType.TYPE;
    }

    static {
        ZERO = NUM_FALSE = new BigDecimal("0");
    }

    private static class ArrayConverterCallback
    implements ArrayCallback {
        private Object retval;
        private Type targetType;

        private ArrayConverterCallback(Object retval, Type targetType) {
            this.retval = retval;
            this.targetType = targetType;
        }

        public LValue getRaw(int row, int column) {
            return new StaticValue(this.retval, this.targetType);
        }

        public Object getValue(int row, int column) throws EvaluationException {
            if (row == 0 && column == 0) {
                return this.retval;
            }
            return null;
        }

        public Type getType(int row, int column) throws EvaluationException {
            if (row == 0 && column == 0) {
                return this.targetType;
            }
            return null;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }
    }
}

