/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.JavaExtensionFunctionFactory;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.java.JRegularExpression;
import net.sf.saxon.java.JavaCollationFactory;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class JavaPlatform
implements Platform {
    private static JavaPlatform theInstance = new JavaPlatform();

    public static JavaPlatform getInstance() {
        return theInstance;
    }

    private JavaPlatform() {
    }

    public void initialize(Configuration config) {
        config.setExtensionFunctionFactory("java", new JavaExtensionFunctionFactory(config));
    }

    public boolean isJava() {
        return true;
    }

    public boolean isDotNet() {
        return false;
    }

    public URI makeAbsolute(String relativeURI, String base) throws URISyntaxException {
        URI absoluteURI;
        block9: {
            if (relativeURI == null) {
                URI absoluteURI2 = new URI(ResolveURI.escapeSpaces(base));
                if (!absoluteURI2.isAbsolute()) {
                    throw new URISyntaxException(base, "Relative URI not supplied, so base URI must be absolute");
                }
                return absoluteURI2;
            }
            relativeURI = ResolveURI.escapeSpaces(relativeURI);
            base = ResolveURI.escapeSpaces(base);
            try {
                if (base == null) {
                    String expandedBase;
                    absoluteURI = new URI(relativeURI);
                    if (!absoluteURI.isAbsolute() && !(expandedBase = ResolveURI.tryToExpand(base)).equals(base)) {
                        return this.makeAbsolute(relativeURI, expandedBase);
                    }
                    break block9;
                }
                if (base != null && base.startsWith("jar:")) {
                    try {
                        URL baseURL = new URL(base);
                        URL absoluteURL = new URL(baseURL, relativeURI);
                        absoluteURI = new URI(absoluteURL.toString());
                        break block9;
                    }
                    catch (MalformedURLException err) {
                        throw new URISyntaxException(base + " " + relativeURI, err.getMessage());
                    }
                }
                URI baseURI = new URI(base);
                new URI(relativeURI);
                absoluteURI = relativeURI.length() == 0 ? baseURI : baseURI.resolve(relativeURI);
            }
            catch (IllegalArgumentException err0) {
                throw new URISyntaxException(relativeURI, "Cannot resolve URI against base " + Err.wrap(base));
            }
        }
        return absoluteURI;
    }

    public String getPlatformVersion() {
        return "Java version " + System.getProperty("java.version");
    }

    public String getPlatformSuffix() {
        return "J";
    }

    public Source getParserSource(Configuration config, StreamSource input, int validation, boolean dtdValidation, int stripspace) {
        return input;
    }

    public RegularExpression compileRegularExpression(CharSequence regex, int xmlVersion, int syntax, CharSequence flags) throws XPathException {
        int flagBits = JRegularExpression.setFlags(flags);
        return new JRegularExpression(regex, xmlVersion, syntax, flagBits);
    }

    public StringCollator makeCollation(Configuration config, Properties props, String uri) throws XPathException {
        return JavaCollationFactory.makeCollation(config, uri, props);
    }

    public boolean canReturnCollationKeys(StringCollator collation) {
        return collation instanceof CodepointCollator || collation instanceof NamedCollation && ((NamedCollation)collation).getCollation() instanceof Collator;
    }

    public Object getCollationKey(NamedCollation namedCollation, String value) {
        return ((Collator)namedCollation.getCollation()).getCollationKey(value);
    }

    public void makeExtensionLibrary(Configuration config) {
        config.setExtensionBinder("java", new JavaExtensionLibrary(config));
    }

    public void addFunctionLibraries(FunctionLibraryList list, Configuration config) {
        list.addFunctionLibrary(config.getExtensionBinder("java"));
    }

    public void declareJavaClass(FunctionLibrary library, String uri, Class theClass) {
        if (!(library instanceof JavaExtensionLibrary)) {
            throw new IllegalStateException("saxon:script cannot be used with a custom extension library factory");
        }
        ((JavaExtensionLibrary)library).declareJavaClass(uri, theClass);
    }

    public SchemaType getExternalObjectType(Configuration config, String uri, String localName) {
        throw new UnsupportedOperationException("getExternalObjectType for Java");
    }
}

