/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.xsltfilter;

import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.xsltfilter.Base64;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.container.XNameContainer;
import com.sun.star.embed.XTransactedObject;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XSeekable;
import com.sun.star.io.XStream;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.FileWriter;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class XSLTFilterOLEExtracter {
    protected XMultiServiceFactory m_xMSF;
    protected XNameContainer m_Storage;
    protected XStream m_RootStream;
    protected XConnection m_Connection;
    protected String sConnectionString;
    private static final String UNO_URL = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
    protected static boolean DEBUG = false;
    protected static boolean DEBUGCHK = false;
    protected static String debugfile;

    public void init(String string) {
        if (string == null || string.equals("")) {
            string = UNO_URL;
        }
        XSLTFilterOLEExtracter.debugln("Init with uno url=" + string);
        if (null == this.m_xMSF) {
            try {
                this.m_xMSF = this.connectAwareGetServiceFactory();
            }
            catch (Exception exception) {
                System.err.println("Could not connect to the office '" + string + "'\n" + exception.getMessage());
            }
        }
    }

    public void exit() {
        this.m_Storage = null;
        this.m_xMSF = null;
        if (null != this.m_Connection) {
            try {
                this.m_Connection.close();
            }
            catch (Exception exception) {
                System.err.println("Could not close connection to the office.\n" + exception.getMessage());
            }
        }
    }

    public void insertByName(String string, String string2) {
        XSLTFilterOLEExtracter.debugln("insertByName(" + string + " : " + string2 + ")");
        if (string.equals("oledata.mso")) {
            this.loadRootStorageFromBase64(string2);
        } else {
            this.ensureCreateRootStorage();
            this.insertSubStorage(string, string2);
        }
    }

    public String getByName(String string) {
        if (string.equals("oledata.mso")) {
            try {
                XSeekable xSeekable = (XSeekable)UnoRuntime.queryInterface(XSeekable.class, (Object)this.m_RootStream);
                int n = (int)xSeekable.getLength();
                xSeekable.seek(0L);
                xSeekable = null;
                XInputStream xInputStream = this.m_RootStream.getInputStream();
                byte[][] byArray = new byte[1][n];
                xInputStream.readBytes(byArray, n);
                return Base64.encodeBytes(byArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return this.getEncodedSubStorage(string);
        }
        return "";
    }

    public String getEncodedSubStorage(String string) {
        XSLTFilterOLEExtracter.debugln("getByName(" + string + ")");
        try {
            if (!this.m_Storage.hasByName(string)) {
                return "Not Found:" + string;
            }
            Object object = this.m_Storage.getByName(string);
            if (object == null) {
                return "Not Found:" + string;
            }
            XInputStream xInputStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, (Object)object);
            if (xInputStream == null) {
                return "Not Found:" + string;
            }
            byte[][] byArray = new byte[1][4];
            XSeekable xSeekable = (XSeekable)UnoRuntime.queryInterface(XSeekable.class, (Object)xInputStream);
            xSeekable.seek(0L);
            xSeekable = null;
            int n = xInputStream.readBytes(byArray, 4);
            if (4 != n) {
                System.out.println("readbytes:" + n);
                return "Can not read the length.";
            }
            int n2 = (byArray[0][0] << 0) + (byArray[0][1] << 8) + (byArray[0][2] << 16) + (byArray[0][3] << 24);
            byte[][] byArray2 = new byte[1][n2];
            n = xInputStream.readBytes(byArray2, n2);
            if (n2 < n) {
                return "oleLength :" + n2 + " readbytes: " + n;
            }
            Inflater inflater = new Inflater();
            inflater.setInput(byArray2[0], 0, n);
            byte[] byArray3 = new byte[n2];
            int n3 = inflater.inflate(byArray3);
            inflater.end();
            return Base64.encodeBytes(byArray3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public XStream CreateTempFileStream(XMultiServiceFactory xMultiServiceFactory) {
        XStream xStream = null;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.io.TempFile");
            xStream = (XStream)UnoRuntime.queryInterface(XStream.class, (Object)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xStream == null) {
            System.out.println("Can't create temporary file!");
        }
        return xStream;
    }

    public void loadRootStorageFromBase64(String string) {
        try {
            byte[] byArray = Base64.decode(string);
            this.m_RootStream = this.CreateTempFileStream(this.m_xMSF);
            XOutputStream xOutputStream = this.m_RootStream.getOutputStream();
            xOutputStream.writeBytes(byArray);
            xOutputStream.flush();
            XInputStream xInputStream = this.m_RootStream.getInputStream();
            XSeekable xSeekable = (XSeekable)UnoRuntime.queryInterface(XSeekable.class, (Object)xInputStream);
            xSeekable.seek(0L);
            byArray = null;
            xSeekable = null;
            Object[] objectArray = new Object[]{xInputStream};
            Object object = this.m_xMSF.createInstanceWithArguments("com.sun.star.embed.OLESimpleStorage", objectArray);
            objectArray = null;
            this.m_Storage = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void ensureCreateRootStorage() {
        if (null == this.m_RootStream || null == this.m_Storage) {
            try {
                this.m_RootStream = this.CreateTempFileStream(this.m_xMSF);
                Object[] objectArray = new Object[]{this.m_RootStream};
                Object object = this.m_xMSF.createInstanceWithArguments("com.sun.star.embed.OLESimpleStorage", objectArray);
                objectArray = null;
                this.m_Storage = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void insertSubStorage(String string, String string2) {
        try {
            byte[] byArray = Base64.decode(string2);
            XStream xStream = this.CreateTempFileStream(this.m_xMSF);
            XInputStream xInputStream = xStream.getInputStream();
            XOutputStream xOutputStream = xStream.getOutputStream();
            byte[] byArray2 = new byte[]{(byte)(byArray.length >>> 0 & 0xFF), (byte)(byArray.length >>> 8 & 0xFF), (byte)(byArray.length >>> 16 & 0xFF), (byte)(byArray.length >>> 24 & 0xFF)};
            xOutputStream.writeBytes(byArray2);
            byte[] byArray3 = new byte[byArray.length];
            Deflater deflater = new Deflater();
            deflater.setInput(byArray);
            deflater.finish();
            int n = deflater.deflate(byArray3);
            byte[] byArray4 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray4[i] = byArray3[i];
            }
            xOutputStream.writeBytes(byArray4);
            XSeekable xSeekable = (XSeekable)UnoRuntime.queryInterface(XSeekable.class, (Object)xInputStream);
            xSeekable.seek(0L);
            xSeekable = null;
            byArray = null;
            XTransactedObject xTransactedObject = (XTransactedObject)UnoRuntime.queryInterface(XTransactedObject.class, (Object)this.m_Storage);
            this.m_Storage.insertByName(string, (Object)xInputStream);
            xTransactedObject.commit();
            xTransactedObject = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static String[] parseUnoUrl(String string) {
        String[] stringArray = new String[3];
        if (!string.startsWith("uno:")) {
            return null;
        }
        int n = string.indexOf(59);
        if (n == -1) {
            return null;
        }
        stringArray[0] = string.substring(4, n);
        int n2 = string.indexOf(59, n + 1);
        if (n == -1) {
            return null;
        }
        stringArray[1] = string.substring(n + 1, n2);
        stringArray[2] = string.substring(n2 + 1);
        return stringArray;
    }

    protected XMultiServiceFactory connectAwareGetServiceFactory() throws com.sun.star.uno.Exception, RuntimeException, Exception {
        XComponentContext xComponentContext = Bootstrap.createInitialComponentContext(null);
        Object object = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.connection.Connector", xComponentContext);
        XConnector xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)object);
        String[] stringArray = XSLTFilterOLEExtracter.parseUnoUrl(this.sConnectionString);
        if (null == stringArray) {
            throw new com.sun.star.uno.Exception("Couldn't parse uno-url " + this.sConnectionString);
        }
        this.m_Connection = xConnector.connect(stringArray[0]);
        object = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.bridge.BridgeFactory", xComponentContext);
        XBridgeFactory xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)object);
        XBridge xBridge = xBridgeFactory.createBridge("", stringArray[1], this.m_Connection, null);
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xBridge);
        object = xBridge.getInstance(stringArray[2]);
        if (null == object) {
            throw new com.sun.star.uno.Exception("Server didn't provide an instance for" + stringArray[2], null);
        }
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)object);
        return xMultiServiceFactory;
    }

    protected static void debugln(String string) {
        XSLTFilterOLEExtracter.debug(string + "\n");
    }

    protected static void debug(String string) {
        if (!DEBUGCHK) {
            if (System.getProperty("xsltfilter.debug") == null) {
                DEBUGCHK = true;
                return;
            }
            debugfile = System.getProperty("xsltfilter.debug");
            DEBUG = true;
        }
        if (!DEBUG) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(debugfile, true);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

