/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho.output;

import com.sun.star.report.pentaho.model.DataStyle;
import com.sun.star.report.pentaho.model.FontFaceDeclsSection;
import com.sun.star.report.pentaho.model.FontFaceElement;
import com.sun.star.report.pentaho.model.OfficeMasterPage;
import com.sun.star.report.pentaho.model.OfficeMasterStyles;
import com.sun.star.report.pentaho.model.OfficeStyle;
import com.sun.star.report.pentaho.model.OfficeStyles;
import com.sun.star.report.pentaho.model.OfficeStylesCollection;
import com.sun.star.report.pentaho.model.PageLayout;
import com.sun.star.report.pentaho.model.RawText;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.structure.StaticText;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StylesWriter {
    private final XmlWriter xmlWriter;
    private final boolean writeOpeningTag;

    public StylesWriter(Writer writer) {
        DefaultTagDescription defaultTagDescription = new DefaultTagDescription();
        defaultTagDescription.configure(JFreeReportBoot.getInstance().getGlobalConfig(), "com.sun.star.report.pentaho.output.");
        this.xmlWriter = new XmlWriter(writer, (TagDescription)defaultTagDescription);
        this.xmlWriter.setAlwaysAddNamespace(true);
        this.writeOpeningTag = true;
    }

    public StylesWriter(XmlWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.writeOpeningTag = false;
    }

    public void writeContentStyles(OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2) throws IOException, ReportProcessingException {
        this.writeFontFaces(new OfficeStylesCollection[]{officeStylesCollection2});
        this.writeAutomaticStylesSection(new OfficeStylesCollection[]{officeStylesCollection2});
    }

    public void writeGlobalStyles(OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2) throws IOException, ReportProcessingException {
        if (this.writeOpeningTag) {
            this.performWriteRootTag();
        }
        this.writeFontFaces(new OfficeStylesCollection[]{officeStylesCollection2});
        this.writeCommonStylesSection(new OfficeStylesCollection[]{officeStylesCollection2});
        this.writeAutomaticStylesSection(new OfficeStylesCollection[]{officeStylesCollection2});
        this.writeMasterStylesSection(new OfficeStylesCollection[]{officeStylesCollection2});
        if (this.writeOpeningTag) {
            this.xmlWriter.writeCloseTag();
        }
    }

    private void writeMasterStylesSection(OfficeStylesCollection[] officeStylesCollectionArray) throws IOException {
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "master-styles", false);
        for (int i = 0; i < officeStylesCollectionArray.length; ++i) {
            OfficeStylesCollection officeStylesCollection = officeStylesCollectionArray[i];
            OfficeMasterStyles officeMasterStyles = officeStylesCollection.getMasterStyles();
            OfficeMasterPage[] officeMasterPageArray = officeMasterStyles.getAllMasterPages();
            for (int j = 0; j < officeMasterPageArray.length; ++j) {
                OfficeMasterPage officeMasterPage = officeMasterPageArray[j];
                this.writeSection(officeMasterPage);
            }
            this.writeSectionChilds(officeMasterStyles.getOtherNodes().getNodeArray());
        }
        this.xmlWriter.writeCloseTag();
    }

    private void writeCommonStylesSection(OfficeStylesCollection[] officeStylesCollectionArray) throws IOException {
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "styles", false);
        for (int i = 0; i < officeStylesCollectionArray.length; ++i) {
            OfficeStylesCollection officeStylesCollection = officeStylesCollectionArray[i];
            OfficeStyles officeStyles = officeStylesCollection.getCommonStyles();
            this.writeStyles(officeStyles);
        }
        this.xmlWriter.writeCloseTag();
    }

    private void writeAutomaticStylesSection(OfficeStylesCollection[] officeStylesCollectionArray) throws IOException {
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "automatic-styles", false);
        for (int i = 0; i < officeStylesCollectionArray.length; ++i) {
            OfficeStylesCollection officeStylesCollection = officeStylesCollectionArray[i];
            OfficeStyles officeStyles = officeStylesCollection.getAutomaticStyles();
            this.writeStyles(officeStyles);
        }
        this.xmlWriter.writeCloseTag();
    }

    private void writeFontFaces(OfficeStylesCollection[] officeStylesCollectionArray) throws IOException {
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "font-face-decls", false);
        TreeMap<String, FontFaceElement> treeMap = new TreeMap<String, FontFaceElement>();
        for (int i = 0; i < officeStylesCollectionArray.length; ++i) {
            Object object = officeStylesCollectionArray[i];
            FontFaceDeclsSection fontFaceDeclsSection = object.getFontFaceDecls();
            FontFaceElement[] fontFaceElementArray = fontFaceDeclsSection.getAllFontFaces();
            for (int j = 0; j < fontFaceElementArray.length; ++j) {
                FontFaceElement fontFaceElement = fontFaceElementArray[j];
                treeMap.put(fontFaceElement.getStyleName(), fontFaceElement);
            }
        }
        for (Object object : treeMap.values()) {
            this.writeElement((Element)object);
        }
        this.xmlWriter.writeCloseTag();
    }

    private void writeStyles(OfficeStyles officeStyles) throws IOException {
        OfficeStyle[] officeStyleArray = officeStyles.getAllStyles();
        for (int i = 0; i < officeStyleArray.length; ++i) {
            OfficeStyle officeStyle = officeStyleArray[i];
            this.writeSection(officeStyle);
        }
        DataStyle[] dataStyleArray = officeStyles.getAllDataStyles();
        for (int i = 0; i < dataStyleArray.length; ++i) {
            DataStyle dataStyle = dataStyleArray[i];
            this.writeSection(dataStyle);
        }
        PageLayout[] pageLayoutArray = officeStyles.getAllPageStyles();
        for (int i = 0; i < pageLayoutArray.length; ++i) {
            PageLayout pageLayout = pageLayoutArray[i];
            this.writeSection(pageLayout);
        }
        this.writeSectionChilds((Node[])officeStyles.getOtherStyles());
    }

    private void writeElement(Element element) throws IOException {
        String string = element.getType();
        String string2 = element.getNamespace();
        AttributeList attributeList = this.buildAttributeList(element.getAttributeMap());
        this.xmlWriter.writeTag(string2, string, attributeList, true);
    }

    private void writeSection(Section section) throws IOException {
        String string = section.getType();
        String string2 = section.getNamespace();
        AttributeList attributeList = this.buildAttributeList(section.getAttributeMap());
        if (section.getNodeCount() == 0) {
            this.xmlWriter.writeTag(string2, string, attributeList, true);
            return;
        }
        this.xmlWriter.writeTag(string2, string, attributeList, false);
        this.writeSectionChilds(section.getNodeArray());
        this.xmlWriter.writeCloseTag();
    }

    private void writeSectionChilds(Node[] nodeArray) throws IOException {
        for (int i = 0; i < nodeArray.length; ++i) {
            RawText rawText;
            Node node = nodeArray[i];
            if (node instanceof Section) {
                this.writeSection((Section)node);
                continue;
            }
            if (node instanceof Element) {
                this.writeElement((Element)node);
                continue;
            }
            if (node instanceof RawText) {
                rawText = (RawText)node;
                this.xmlWriter.writeText(rawText.getText());
                continue;
            }
            if (!(node instanceof StaticText)) continue;
            rawText = (StaticText)node;
            this.xmlWriter.writeTextNormalized(rawText.getText(), false);
        }
    }

    protected AttributeList buildAttributeList(AttributeMap attributeMap) {
        AttributeList attributeList = new AttributeList();
        String[] stringArray = attributeMap.getNameSpaces();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.isFilteredNamespace(string)) continue;
            Map map = attributeMap.getAttributes(string);
            for (Map.Entry entry : map.entrySet()) {
                String string2 = String.valueOf(entry.getKey());
                attributeList.setAttribute(string, string2, String.valueOf(entry.getValue()));
            }
        }
        return attributeList;
    }

    protected boolean isFilteredNamespace(String string) {
        if ("http://jfreereport.sourceforge.net/namespaces/layout".equals(string)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine".equals(string)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine/compatibility".equals(string)) {
            return true;
        }
        return "http://openoffice.org/2005/report".equals(string);
    }

    private void performWriteRootTag() throws IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.addNamespaceDeclaration("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        attributeList.addNamespaceDeclaration("style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        attributeList.addNamespaceDeclaration("text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        attributeList.addNamespaceDeclaration("table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        attributeList.addNamespaceDeclaration("draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        attributeList.addNamespaceDeclaration("fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        attributeList.addNamespaceDeclaration("xlink", "http://www.w3.org/1999/xlink");
        attributeList.addNamespaceDeclaration("dc", "http://purl.org/dc/elements/1.1/");
        attributeList.addNamespaceDeclaration("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        attributeList.addNamespaceDeclaration("number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        attributeList.addNamespaceDeclaration("svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        attributeList.addNamespaceDeclaration("chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        attributeList.addNamespaceDeclaration("chartooo", "http://openoffice.org/2010/chart");
        attributeList.addNamespaceDeclaration("dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        attributeList.addNamespaceDeclaration("math", "http://www.w3.org/1998/Math/MathML");
        attributeList.addNamespaceDeclaration("form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        attributeList.addNamespaceDeclaration("script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        attributeList.addNamespaceDeclaration("ooo", "http://openoffice.org/2004/office");
        attributeList.addNamespaceDeclaration("ooow", "http://openoffice.org/2004/writer");
        attributeList.addNamespaceDeclaration("oooc", "http://openoffice.org/2004/calc");
        attributeList.addNamespaceDeclaration("dom", "http://www.w3.org/2001/xml-events");
        attributeList.addNamespaceDeclaration("xforms", "http://www.w3.org/2002/xforms");
        attributeList.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        attributeList.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        attributeList.addNamespaceDeclaration("grddl", "http://www.w3.org/2003/g/data-view#");
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", "1.2");
        this.xmlWriter.writeXmlDeclaration("UTF-8");
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "document-styles", attributeList, false);
    }

    public void close() throws IOException {
        this.xmlWriter.close();
    }
}

