/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.embed.InvalidStorageException;
import com.sun.star.embed.XStorage;
import com.sun.star.embed.XTransactedObject;
import com.sun.star.io.XStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lib.uno.adapter.XInputStreamToInputStreamAdapter;
import com.sun.star.lib.uno.adapter.XOutputStreamToOutputStreamAdapter;
import com.sun.star.report.InputRepository;
import com.sun.star.report.OutputRepository;
import com.sun.star.report.SDBCReportDataFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageRepository
implements InputRepository,
OutputRepository {
    private static final Log LOGGER = LogFactory.getLog(SDBCReportDataFactory.class);
    private static final String REPORT_PROCESSING_FAILED = "ReportProcessing failed";
    private XStorage input;
    private XStorage output;
    private final String rootURL;

    public StorageRepository(XStorage xStorage, XStorage xStorage2, String string) {
        this.input = xStorage;
        this.output = xStorage2;
        this.rootURL = string;
    }

    public StorageRepository(XStorage xStorage, boolean bl, String string) {
        this.rootURL = string;
        if (bl) {
            this.output = xStorage;
        } else {
            this.input = xStorage;
        }
    }

    public InputStream createInputStream(String string) throws IOException {
        if (this.input == null) {
            throw new IOException("input is NULL");
        }
        try {
            XStream xStream = (XStream)UnoRuntime.queryInterface(XStream.class, (Object)this.input.openStreamElement(string, 1));
            return new BufferedInputStream((InputStream)new XInputStreamToInputStreamAdapter(xStream.getInputStream()), 102400);
        }
        catch (Exception exception) {
            throw new IOException("createInputStream");
        }
    }

    public OutputStream createOutputStream(String string, String string2) throws IOException {
        if (this.output == null) {
            throw new IOException("output is NULL");
        }
        try {
            XStream xStream = this.output.openStreamElement(string, 12);
            xStream.getInputStream().closeInput();
            if (string2 != null) {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xStream);
                xPropertySet.setPropertyValue("MediaType", (Object)string2);
            }
            return new BufferedOutputStream((OutputStream)new XOutputStreamToOutputStreamAdapter(xStream.getOutputStream()), 204800);
        }
        catch (Exception exception) {
            throw new IOException("createOutputStream");
        }
    }

    public boolean exists(String string) {
        try {
            return this.output.isStreamElement(string);
        }
        catch (InvalidStorageException invalidStorageException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)invalidStorageException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)illegalArgumentException);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    public boolean isWritable(String string) {
        return true;
    }

    public Object getId() {
        return "1";
    }

    public long getVersion(String string) {
        return 1L;
    }

    public boolean isReadable(String string) {
        try {
            if (this.input != null) {
                return this.input.isStreamElement(string);
            }
        }
        catch (InvalidStorageException invalidStorageException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)invalidStorageException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)illegalArgumentException);
        }
        catch (NoSuchElementException noSuchElementException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)noSuchElementException);
        }
        return false;
    }

    public InputRepository openInputRepository(String string) throws IOException {
        try {
            String string2 = this.shortenName(string);
            if (!this.input.isStorageElement(string2)) {
                throw new IOException();
            }
            XStorage xStorage = (XStorage)UnoRuntime.queryInterface(XStorage.class, (Object)this.input.openStorageElement(string2, 1));
            return new StorageRepository(xStorage, false, this.rootURL);
        }
        catch (NoSuchElementException noSuchElementException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)noSuchElementException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)wrappedTargetException);
        }
        catch (InvalidStorageException invalidStorageException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)invalidStorageException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)illegalArgumentException);
        }
        catch (com.sun.star.io.IOException iOException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)iOException);
        }
        throw new IOException();
    }

    final String shortenName(String string) {
        String string2 = string.startsWith("./") ? string.substring(2) : string;
        return string2;
    }

    public OutputRepository openOutputRepository(String string, String string2) throws IOException {
        try {
            String string3 = this.shortenName(string);
            XStorage xStorage = (XStorage)UnoRuntime.queryInterface(XStorage.class, (Object)this.output.openStorageElement(string3, 4));
            if (string2 != null) {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xStorage);
                xPropertySet.setPropertyValue("MediaType", (Object)string2);
            }
            return new StorageRepository(xStorage, true, this.rootURL);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)unknownPropertyException);
        }
        catch (PropertyVetoException propertyVetoException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)propertyVetoException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)illegalArgumentException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)wrappedTargetException);
        }
        catch (InvalidStorageException invalidStorageException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)invalidStorageException);
        }
        catch (com.sun.star.io.IOException iOException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)iOException);
        }
        throw new IOException();
    }

    public void closeInputRepository() {
        if (this.input != null) {
            this.input.dispose();
        }
    }

    public void closeOutputRepository() {
        if (this.output != null) {
            try {
                XTransactedObject xTransactedObject = (XTransactedObject)UnoRuntime.queryInterface(XTransactedObject.class, (Object)this.output);
                if (xTransactedObject != null) {
                    xTransactedObject.commit();
                }
            }
            catch (com.sun.star.io.IOException iOException) {
                LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)iOException);
            }
            catch (WrappedTargetException wrappedTargetException) {
                LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)wrappedTargetException);
            }
            this.output.dispose();
        }
    }

    public boolean existsStorage(String string) {
        try {
            return this.output.isStorageElement(string);
        }
        catch (InvalidStorageException invalidStorageException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)invalidStorageException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)illegalArgumentException);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    public String getRootURL() {
        return this.rootURL;
    }
}

