/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class Row
implements BIFFRecord {
    private byte[] rw = new byte[2];
    private byte[] miyRw = new byte[2];
    private byte[] grbit = new byte[2];
    private byte[] ixfe = new byte[2];
    private float scale = 1.0f;

    public Row(int n, int n2, boolean bl) {
        this.rw = EndianConverter.writeShort((short)n);
        n2 = (int)((float)n2 * this.scale);
        this.miyRw = EndianConverter.writeShort((short)n2);
        this.grbit = bl ? EndianConverter.writeShort((short)2) : EndianConverter.writeShort((short)0);
        this.ixfe = EndianConverter.writeShort((short)0);
    }

    public Row(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    @Override
    public short getBiffType() {
        return 8;
    }

    public short getRowHeight() {
        return EndianConverter.readShort(this.miyRw);
    }

    public short getRowNumber() {
        return EndianConverter.readShort(this.rw);
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.rw);
        n += inputStream.read(this.miyRw);
        short s = (short)((float)EndianConverter.readShort(this.miyRw) / this.scale);
        this.miyRw = EndianConverter.writeShort(s);
        n += inputStream.read(this.grbit);
        Debug.log(4, "\trw : " + EndianConverter.readShort(this.rw) + " miyRw : " + EndianConverter.readShort(this.miyRw) + " grbit : " + EndianConverter.readShort(this.grbit) + " ixfe : " + EndianConverter.readShort(this.ixfe));
        return n += inputStream.read(this.ixfe);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.rw);
        outputStream.write(this.miyRw);
        outputStream.write(this.grbit);
        outputStream.write(this.ixfe);
        Debug.log(4, "Writing Row record");
    }
}

