/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class DefRowHeight
implements BIFFRecord {
    private byte[] unknown1 = new byte[2];
    private byte[] unknown2 = new byte[2];

    public DefRowHeight() {
        this.unknown1 = new byte[]{0, 0};
        this.unknown2 = new byte[]{-1, 0};
    }

    public DefRowHeight(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    @Override
    public short getBiffType() {
        return 37;
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.unknown1);
        Debug.log(4, "\tunknown1 : " + EndianConverter.readShort(this.unknown1) + " unknown2 : " + EndianConverter.readShort(this.unknown2));
        return n += inputStream.read(this.unknown2);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.unknown1);
        outputStream.write(this.unknown2);
        Debug.log(4, "Writing DefRowHeight record");
    }
}

