/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndefNode
extends Node {
    private Node name;

    public UndefNode(ISourcePosition position, Node name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNDEFNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitUndefNode(this);
    }

    public Node getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.name);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyModule module = context.getRubyClass();
        String undefName = RuntimeHelpers.interpretAliasUndefName(this.name, runtime2, context, self, aBlock);
        if (module == null) {
            throw runtime2.newTypeError("No class to undef method '" + undefName + "'.");
        }
        module.undef(context, undefName);
        return runtime2.getNil();
    }
}

