/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.MessageImpl;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;

public class AntMessageImpl
implements MessageImpl {
    private Task _task;
    private static long _lastProgressFlush = 0L;
    private static StringBuffer _buf = new StringBuffer();

    public AntMessageImpl(Task task) {
        this._task = task;
        task.getProject().addBuildListener(new BuildListener(){
            private int stackDepth = 0;

            public void buildFinished(BuildEvent event) {
            }

            public void buildStarted(BuildEvent event) {
            }

            public void targetStarted(BuildEvent event) {
            }

            public void targetFinished(BuildEvent event) {
            }

            public void taskStarted(BuildEvent event) {
                ++this.stackDepth;
            }

            public void taskFinished(BuildEvent event) {
                if (this.stackDepth == 0) {
                    Message.uninit();
                    event.getProject().removeBuildListener((BuildListener)this);
                }
                --this.stackDepth;
            }

            public void messageLogged(BuildEvent event) {
            }
        });
    }

    public void log(String msg, int level) {
        this._task.log(msg, level);
    }

    public void rawlog(String msg, int level) {
        this._task.getProject().log(msg, level);
    }

    public void progress() {
        _buf.append(".");
        if (_lastProgressFlush == 0L) {
            _lastProgressFlush = System.currentTimeMillis();
        }
        if (this._task != null && System.currentTimeMillis() - _lastProgressFlush > 1500L) {
            this._task.log(_buf.toString());
            _buf.setLength(0);
            _lastProgressFlush = System.currentTimeMillis();
        }
    }

    public void endProgress(String msg) {
        this._task.log(_buf + msg);
        _buf.setLength(0);
        _lastProgressFlush = 0L;
    }
}

