/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final Map myMap;
    private final ReferenceQueue myReferenceQueue = new ReferenceQueue();
    private final HardKey myHardKeyInstance = new HardKey("");
    private Set entrySet = null;

    private void processQueue() {
        WeakKey wk;
        while ((wk = (WeakKey)this.myReferenceQueue.poll()) != null) {
            this.myMap.remove(wk);
        }
    }

    public WeakHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new THashMap(initialCapacity, loadFactor);
    }

    public WeakHashMap(int initialCapacity) {
        this.myMap = new THashMap(initialCapacity);
    }

    public WeakHashMap() {
        this.myMap = new THashMap();
    }

    public WeakHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.myMap.containsKey(null);
        }
        this.myHardKeyInstance.set(key);
        boolean result = this.myMap.containsKey(this.myHardKeyInstance);
        this.myHardKeyInstance.set(null);
        return result;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.myMap.get(null);
        }
        this.myHardKeyInstance.set(key);
        Object result = this.myMap.get(this.myHardKeyInstance);
        this.myHardKeyInstance.set(null);
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        return this.myMap.put(WeakKey.create(key, this.myReferenceQueue), value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        if (key == null) {
            return this.myMap.remove(null);
        }
        this.myHardKeyInstance.set(key);
        Object result = this.myMap.remove(this.myHardKeyInstance);
        this.myHardKeyInstance.set(null);
        return result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class EntrySet
    extends AbstractSet {
        private final Set<Map.Entry> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = WeakHashMap.this.myMap.entrySet();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private final Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = (Map.Entry)this.hashIterator.next();
                        WeakKey wk = (WeakKey)ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object t = wk.get();
                            k = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, k);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            WeakHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            WeakHashMap.this.myHardKeyInstance.set(o);
            HardKey key = WeakHashMap.this.myHardKeyInstance;
            Object hv = WeakHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && WeakHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                WeakHashMap.this.myMap.remove(key);
            }
            WeakHashMap.this.myHardKeyInstance.set(null);
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                WeakKey wk = (WeakKey)entry.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = entry.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class Entry
    implements Map.Entry {
        private final Map.Entry ent;
        private final Object key;

        Entry(Map.Entry ent, Object key) {
            this.ent = ent;
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.ent.getValue();
        }

        public Object setValue(Object value) {
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Entry.valEquals(this.key, e.getKey()) && Entry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            Object v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey
    implements Key {
        private Object myObject;
        private int myHash;

        public HardKey(Object object) {
            this.myObject = object;
            this.myHash = object.hashCode();
        }

        @Override
        public Object get() {
            return this.myObject;
        }

        public void set(Object object) {
            this.myObject = object;
            this.myHash = object != null ? object.hashCode() : 0;
        }

        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.get();
            if (t == (u = ((Key)o).get())) {
                return true;
            }
            if (t == null || u == null) {
                return false;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    private static class WeakKey
    extends WeakReference
    implements Key {
        private final int myHash;

        private WeakKey(Object k, ReferenceQueue q) {
            super(k, q);
            this.myHash = k.hashCode();
        }

        private static WeakKey create(Object k, ReferenceQueue q) {
            return k != null ? new WeakKey(k, q) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }

        public String toString() {
            Object t = this.get();
            if (t != null) {
                return "WeakKey(" + t.toString() + ")";
            }
            return super.toString();
        }
    }

    private static interface Key {
        public Object get();
    }
}

