/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SortedList<T>
extends AbstractList<T> {
    private final Comparator<T> myComparator;
    private boolean mySorted;
    private final List<T> myDelegate = new ArrayList<T>();

    public SortedList(Comparator<T> comparator) {
        this.myComparator = comparator;
    }

    @Override
    public void add(int index, T element) {
        this.mySorted = false;
        this.myDelegate.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.myDelegate.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.ensureSorted();
        int i = Collections.binarySearch(this.myDelegate, o, this.myComparator);
        if (i >= 0) {
            this.myDelegate.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public T get(int index) {
        this.ensureSorted();
        return this.myDelegate.get(index);
    }

    private void ensureSorted() {
        if (!this.mySorted) {
            this.sort(this.myDelegate);
            this.mySorted = true;
        }
    }

    public void markDirty() {
        this.mySorted = false;
    }

    @Override
    protected void sort(List<T> delegate) {
        Collections.sort(this.myDelegate, this.myComparator);
    }

    @Override
    public void clear() {
        this.myDelegate.clear();
    }

    @Override
    public Iterator<T> iterator() {
        this.ensureSorted();
        return super.iterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        this.ensureSorted();
        return super.listIterator();
    }

    @Override
    public int size() {
        return this.myDelegate.size();
    }
}

