/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;

public interface DiffCorrection {
    public DiffFragment[] correct(DiffFragment[] var1);

    public static class ConnectSingleSideToChange
    implements DiffCorrection,
    FragmentProcessor<FragmentBuffer> {
        public static final ConnectSingleSideToChange INSTANCE = new ConnectSingleSideToChange();
        private static final int CHANGE = 1;

        @Override
        public DiffFragment[] correct(DiffFragment[] fragments) {
            FragmentBuffer buffer = new FragmentBuffer();
            buffer.processAll(fragments, this);
            return buffer.toArray();
        }

        @Override
        public void process(DiffFragment fragment, FragmentBuffer buffer) {
            if (fragment.isEqual()) {
                buffer.add(fragment);
            } else if (fragment.isOneSide()) {
                String text = FragmentSide.chooseSide(fragment).getText(fragment);
                if (StringUtil.endsWithChar(text, '\n')) {
                    buffer.add(fragment);
                } else {
                    buffer.markIfNone(1);
                }
            } else {
                buffer.markIfNone(1);
            }
        }
    }

    public static class Normalize
    implements DiffCorrection {
        public static final DiffCorrection INSTANCE = new Normalize();

        private Normalize() {
        }

        @Override
        public DiffFragment[] correct(DiffFragment[] fragments) {
            return UnitEquals.INSTANCE.correct(ConcatenateSingleSide.INSTANCE.correct(fragments));
        }
    }

    public static class UnitEquals
    implements DiffCorrection,
    FragmentProcessor<FragmentBuffer> {
        public static final DiffCorrection INSTANCE = new UnitEquals();
        private static final int EQUAL_MODE = 1;
        private static final int FORMATTING_MODE = 2;

        @Override
        public DiffFragment[] correct(DiffFragment[] fragments) {
            FragmentBuffer buffer = new FragmentBuffer();
            buffer.processAll(fragments, this);
            return buffer.toArray();
        }

        @Override
        public void process(DiffFragment fragment, FragmentBuffer buffer) {
            if (fragment.isEqual()) {
                buffer.markIfNone(1);
            } else if (ComparisonPolicy.TRIM_SPACE.isEqual(fragment)) {
                buffer.markIfNone(2);
            } else {
                buffer.add(fragment);
            }
        }
    }

    public static class ConcatenateSingleSide
    implements DiffCorrection,
    FragmentProcessor<FragmentBuffer> {
        public static final DiffCorrection INSTANCE = new ConcatenateSingleSide();
        private static final int DEFAULT_MODE = 1;

        @Override
        public DiffFragment[] correct(DiffFragment[] fragments) {
            FragmentBuffer buffer = new FragmentBuffer();
            buffer.processAll(fragments, this);
            return buffer.toArray();
        }

        @Override
        public void process(DiffFragment fragment, FragmentBuffer buffer) {
            if (fragment.isOneSide()) {
                buffer.markIfNone(1);
            } else {
                buffer.add(fragment);
            }
        }
    }

    public static class FragmentBuffer
    extends BaseFragmentRunner<FragmentBuffer> {
        private int myMark = -1;
        private int myMarkMode = -1;

        public void markIfNone(int mode) {
            if (mode == this.myMarkMode || this.myMark == -1) {
                if (this.myMark == -1) {
                    this.myMark = this.getIndex();
                }
            } else {
                this.flushMarked();
                this.myMark = this.getIndex();
            }
            this.myMarkMode = mode;
        }

        @Override
        public void add(DiffFragment fragment) {
            this.flushMarked();
            super.add(fragment);
        }

        protected void flushMarked() {
            if (this.myMark != -1) {
                this.actualAdd(Util.concatenate(this.getFragments(), this.myMark, this.getIndex()));
                this.myMark = -1;
            }
        }

        @Override
        public void processAll(DiffFragment[] fragments, FragmentProcessor<FragmentBuffer> processor) {
            super.processAll(fragments, processor);
            this.flushMarked();
        }
    }

    public static class FragmentsCollector
    extends BaseFragmentRunner<FragmentsCollector> {
        public void addAll(DiffFragment[] fragments) {
            for (int i = 0; i < fragments.length; ++i) {
                this.add(fragments[i]);
            }
        }
    }

    public static class BaseFragmentRunner<ActualRunner extends BaseFragmentRunner> {
        private final ArrayList<DiffFragment> myItems = new ArrayList();
        private int myIndex = 0;
        private DiffFragment[] myFragments;

        public void add(DiffFragment fragment) {
            this.actualAdd(fragment);
        }

        protected final void actualAdd(DiffFragment fragment) {
            if (BaseFragmentRunner.isEmpty(fragment)) {
                return;
            }
            this.myItems.add(fragment);
        }

        public DiffFragment[] toArray() {
            return this.myItems.toArray(new DiffFragment[this.myItems.size()]);
        }

        protected int getIndex() {
            return this.myIndex;
        }

        public DiffFragment[] getFragments() {
            return this.myFragments;
        }

        public void processAll(DiffFragment[] fragments, FragmentProcessor<ActualRunner> processor) {
            this.myFragments = fragments;
            while (this.myIndex < this.myFragments.length) {
                DiffFragment fragment = this.myFragments[this.myIndex];
                processor.process(fragment, this);
                ++this.myIndex;
            }
        }

        public static int getTextLength(String text) {
            return text != null ? text.length() : 0;
        }

        public static boolean isEmpty(DiffFragment fragment) {
            return BaseFragmentRunner.getTextLength(fragment.getText1()) == 0 && BaseFragmentRunner.getTextLength(fragment.getText2()) == 0;
        }
    }

    public static interface FragmentProcessor<Collector> {
        public void process(DiffFragment var1, Collector var2);
    }

    public static class ChangedSpace
    implements DiffCorrection,
    FragmentProcessor<FragmentsCollector> {
        private final DiffPolicy myDiffPolicy;
        private final ComparisonPolicy myComparisonPolicy;

        public ChangedSpace(ComparisonPolicy policy) {
            this.myComparisonPolicy = policy;
            this.myDiffPolicy = new DiffPolicy.ByChar(this.myComparisonPolicy);
        }

        @Override
        public void process(DiffFragment fragment, FragmentsCollector collector) {
            if (!fragment.isChange()) {
                collector.add(fragment);
                return;
            }
            String text1 = fragment.getText1();
            String text2 = fragment.getText2();
            while (StringUtil.startsWithChar(text1, '\n') || StringUtil.startsWithChar(text2, '\n')) {
                String newLine1 = null;
                String newLine2 = null;
                if (StringUtil.startsWithChar(text1, '\n')) {
                    newLine1 = "\n";
                    text1 = text1.substring(1);
                }
                if (StringUtil.startsWithChar(text2, '\n')) {
                    newLine2 = "\n";
                    text2 = text2.substring(1);
                }
                collector.add(new DiffFragment(newLine1, newLine2));
            }
            String spaces1 = this.leadingSpaces(text1);
            String spaces2 = this.leadingSpaces(text2);
            if (spaces1.length() == 0 && spaces2.length() == 0) {
                DiffFragment trailing = this.myComparisonPolicy.createFragment(text1, text2);
                collector.add(trailing);
                return;
            }
            collector.addAll(this.myDiffPolicy.buildFragments(spaces1, spaces2));
            DiffFragment textFragment = this.myComparisonPolicy.createFragment(text1.substring(spaces1.length(), text1.length()), text2.substring(spaces2.length(), text2.length()));
            collector.add(textFragment);
        }

        private String leadingSpaces(String text) {
            int i;
            for (i = 0; i < text.length() && text.charAt(i) == ' '; ++i) {
            }
            return text.substring(0, i);
        }

        @Override
        public DiffFragment[] correct(DiffFragment[] fragments) {
            FragmentsCollector collector = new FragmentsCollector();
            collector.processAll(fragments, this);
            return collector.toArray();
        }
    }

    public static class TrueLineBlocks
    implements DiffCorrection,
    FragmentProcessor<FragmentsCollector> {
        private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.DiffCorrection.TrueLineBlocks");
        private final DiffPolicy myDiffPolicy;
        private final ComparisonPolicy myComparisonPolicy;

        public TrueLineBlocks(ComparisonPolicy comparisonPolicy) {
            this.myDiffPolicy = new DiffPolicy.LineBlocks(comparisonPolicy);
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        public DiffFragment[] correct(DiffFragment[] fragments) {
            FragmentsCollector collector = new FragmentsCollector();
            collector.processAll(fragments, this);
            return collector.toArray();
        }

        @Override
        public void process(DiffFragment fragment, FragmentsCollector collector) {
            if (!fragment.isEqual()) {
                if (this.myComparisonPolicy.isEqual(fragment)) {
                    fragment = this.myComparisonPolicy.createFragment(fragment.getText1(), fragment.getText2());
                }
                collector.add(fragment);
            } else {
                String[] lines2;
                String[] lines1 = new LineTokenizer(fragment.getText1()).execute();
                LOG.assertTrue(lines1.length == (lines2 = new LineTokenizer(fragment.getText2()).execute()).length);
                for (int i = 0; i < lines1.length; ++i) {
                    collector.addAll(this.myDiffPolicy.buildFragments(lines1[i], lines2[i]));
                }
            }
        }

        public DiffFragment[] correctAndNormalize(DiffFragment[] fragments) {
            return Normalize.INSTANCE.correct(this.correct(fragments));
        }
    }
}

