/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit.segments;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;

class TraceFilter {
    private final String myTrace;
    private final Vector myLines = new Vector();

    public TraceFilter(String trace) {
        this.myTrace = trace;
    }

    public String execute() {
        int i;
        try {
            this.readLines();
        }
        catch (IOException e) {
            return this.myTrace;
        }
        int traceLastLine = this.firstJUnitLine(this.myLines.size() - 1, true);
        if (traceLastLine < 0) {
            return "";
        }
        int traceFirstLine = this.firstJUnitLine(traceLastLine, false);
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        for (i = 0; i < traceFirstLine; ++i) {
            writer.println(this.myLines.elementAt(i));
        }
        for (i = traceLastLine; i < this.myLines.size(); ++i) {
            writer.println(this.myLines.elementAt(i));
        }
        writer.flush();
        return buffer.toString();
    }

    private int firstJUnitLine(int startFrom, boolean searchForJUnitLines) {
        for (int i = startFrom; i >= 0; --i) {
            String line = (String)this.myLines.elementAt(i);
            if (this.isIdeaJUnit(line) != searchForJUnitLines) continue;
            return i;
        }
        return startFrom;
    }

    private boolean isIdeaJUnit(String line) {
        return line.indexOf("com.intellij.rt") >= 0;
    }

    private void readLines() throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(this.myTrace));
        while ((line = reader.readLine()) != null) {
            this.myLines.addElement(line);
        }
        reader.close();
    }
}

