/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit.segments;

import com.intellij.rt.execution.junit.segments.Packet;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.rt.execution.junit.segments.SegmentedStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class SegmentedOutputStream
extends OutputStream
implements PacketProcessor {
    private final PrintStream myPrintStream;
    private boolean myStarted = false;

    public SegmentedOutputStream(PrintStream transportStream) {
        this.myPrintStream = transportStream;
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public synchronized void write(int b) throws IOException {
        if (b == 47 && this.myStarted) {
            this.writeNext(b);
        }
        this.writeNext(b);
        this.flush();
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    public synchronized void flush() throws IOException {
        this.myPrintStream.flush();
    }

    public synchronized void close() throws IOException {
        this.myPrintStream.close();
    }

    private void writeNext(int b) {
        this.myPrintStream.write(b);
    }

    public synchronized void processPacket(String packet) {
        if (!this.myStarted) {
            this.sendStart();
        }
        this.writeNext(SegmentedStream.MARKER_PREFIX);
        String encodedPacket = Packet.encode(packet);
        this.writeNext(String.valueOf(encodedPacket.length()) + " " + encodedPacket);
    }

    private void writeNext(String string) {
        try {
            this.myPrintStream.write(string.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void sendStart() {
        this.writeNext("@#IJIDEA#JUnitSupport#@");
        this.myStarted = true;
    }
}

