/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceWhileLoopWithDoWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        WhileLoopPredicate whileLoopPredicate = new WhileLoopPredicate();
        if (whileLoopPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/whileloop/ReplaceWhileLoopWithDoWhileLoopIntention.getElementPredicate must not return null");
        }
        return whileLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/whileloop/ReplaceWhileLoopWithDoWhileLoopIntention.processIntention must not be null");
        }
        PsiWhileStatement whileStatement = (PsiWhileStatement)element.getParent();
        if (whileStatement == null) {
            return;
        }
        PsiStatement body = whileStatement.getBody();
        StringBuilder doWhileStatementText = new StringBuilder("if(");
        PsiExpression condition = whileStatement.getCondition();
        if (condition != null) {
            doWhileStatementText.append(condition.getText());
        }
        doWhileStatementText.append(") {\n");
        if (body instanceof PsiBlockStatement) {
            doWhileStatementText.append("do {");
            PsiBlockStatement blockStatement = (PsiBlockStatement)body;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                for (int i = 1; i < children.length - 1; ++i) {
                    PsiElement child = children[i];
                    doWhileStatementText.append(child.getText());
                }
            }
            doWhileStatementText.append('}');
        } else if (body != null) {
            doWhileStatementText.append(body.getText());
        }
        doWhileStatementText.append("while(");
        if (condition != null) {
            doWhileStatementText.append(condition.getText());
        }
        doWhileStatementText.append(");\n}");
        ReplaceWhileLoopWithDoWhileLoopIntention.replaceStatement(doWhileStatementText.toString(), (PsiStatement)whileStatement);
    }
}

