/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.enumswitch;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.enumswitch.EnumSwitchPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CreateEnumSwitchBranchesIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        EnumSwitchPredicate enumSwitchPredicate = new EnumSwitchPredicate();
        if (enumSwitchPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/enumswitch/CreateEnumSwitchBranchesIntention.getElementPredicate must not return null");
        }
        return enumSwitchPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiStatement[] statements;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/enumswitch/CreateEnumSwitchBranchesIntention.processIntention must not be null");
        }
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)element;
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return;
        }
        PsiExpression switchExpression = switchStatement.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiClassType switchType = (PsiClassType)switchExpression.getType();
        if (switchType == null) {
            return;
        }
        PsiClass enumClass = switchType.resolve();
        if (enumClass == null) {
            return;
        }
        PsiField[] fields = enumClass.getFields();
        ArrayList<String> missingEnumElements = new ArrayList<String>(fields.length);
        for (PsiField field : fields) {
            if (!(field instanceof PsiEnumConstant)) continue;
            missingEnumElements.add(field.getName());
        }
        for (PsiStatement statement : statements = body.getStatements()) {
            PsiReferenceExpression reference;
            PsiElement resolved;
            PsiSwitchLabelStatement labelStatement;
            PsiExpression value;
            if (!(statement instanceof PsiSwitchLabelStatement) || !((value = (labelStatement = (PsiSwitchLabelStatement)statement).getCaseValue()) instanceof PsiReferenceExpression) || !((resolved = (reference = (PsiReferenceExpression)value).resolve()) instanceof PsiEnumConstant)) continue;
            PsiEnumConstant enumConstant = (PsiEnumConstant)resolved;
            missingEnumElements.remove(enumConstant.getName());
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("switch(");
        buffer.append(switchExpression.getText());
        buffer.append("){");
        PsiElement[] children = body.getChildren();
        for (int i = 1; i < children.length - 1; ++i) {
            buffer.append(children[i].getText());
        }
        for (String missingEnumElement : missingEnumElements) {
            buffer.append("case ");
            buffer.append(missingEnumElement);
            buffer.append(": break;");
        }
        buffer.append('}');
        String newStatement = buffer.toString();
        CreateEnumSwitchBranchesIntention.replaceStatement(newStatement, (PsiStatement)switchStatement);
    }
}

