/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.RemoveConditionalPredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class RemoveConditionalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        RemoveConditionalPredicate removeConditionalPredicate = new RemoveConditionalPredicate();
        if (removeConditionalPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/conditional/RemoveConditionalIntention.getElementPredicate must not return null");
        }
        return removeConditionalPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiConditionalExpression expression = (PsiConditionalExpression)element;
        PsiExpression condition = expression.getCondition();
        PsiExpression thenExpression = expression.getThenExpression();
        assert (thenExpression != null);
        String thenExpressionText = thenExpression.getText();
        if ("true".equals(thenExpressionText)) {
            String newExpression = condition.getText();
            RemoveConditionalIntention.replaceExpression(newExpression, (PsiExpression)expression);
        } else {
            String newExpression = BoolUtils.getNegatedExpressionText(condition);
            RemoveConditionalIntention.replaceExpression(newExpression, (PsiExpression)expression);
        }
    }
}

