/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.IntegerSpinnerModel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalendarView
extends JPanel {
    private static final int[] DAYS_IN_THE_MONTH = new int[]{31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private final JComboBox myDays = new JComboBox();
    private final JComboBox myMonths = new JComboBox();
    private final JSpinner myYears = new JSpinner(new IntegerSpinnerModel(0, -1));
    private final JSpinner myHours = new JSpinner(new IntegerSpinnerModel(0, 24));
    private final JSpinner myMinutes = new JSpinner(new IntegerSpinnerModel(0, 60));
    private final JSpinner mySeconds = new JSpinner(new IntegerSpinnerModel(0, 60));
    private final Calendar myCalendar = Calendar.getInstance();

    public CalendarView() {
        super(new GridLayout(2, 0));
        this.fillMonths();
        this.myYears.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CalendarView.this.refresh();
            }
        });
        this.setDate(new Date());
        this.addDateFields();
        this.addTimeFields();
        int height = Math.max(this.myYears.getPreferredSize().height, this.myDays.getPreferredSize().height);
        height = Math.max(this.myMonths.getPreferredSize().height, height);
        this.myDays.setPreferredSize(new Dimension(this.myDays.getPreferredSize().width, height));
        this.myYears.setPreferredSize(new Dimension(this.myYears.getPreferredSize().width, height));
        this.myMonths.setPreferredSize(new Dimension(this.myMonths.getPreferredSize().width, height));
        Dimension preferredSize = this.getPreferredSize();
        this.setMaximumSize(preferredSize);
        this.setMaximumSize(preferredSize);
    }

    private void fillMonths() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.getDefault());
        for (int i = 0; i <= 11; ++i) {
            this.myMonths.addItem(dateFormatSymbols.getMonths()[i]);
        }
        this.myMonths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarView.this.refresh();
            }
        });
    }

    public void setDate(Date date) {
        this.myCalendar.setTime(date);
        this.myYears.setValue(new Integer(this.myCalendar.get(1)));
        this.myMonths.setSelectedIndex(this.myCalendar.get(2));
        this.myDays.setSelectedIndex(this.myCalendar.get(5) - 1);
        this.myHours.setValue(new Integer(this.myCalendar.get(11)));
        this.myMinutes.setValue(new Integer(this.myCalendar.get(12)));
        this.mySeconds.setValue(new Integer(this.myCalendar.get(13)));
    }

    private void addTimeFields() {
        JPanel timePanel = new JPanel(new FlowLayout(2));
        timePanel.add(this.myHours);
        timePanel.add(new JLabel(" : "));
        timePanel.add(this.myMinutes);
        timePanel.add(new JLabel(" : "));
        timePanel.add(this.mySeconds);
        this.add(timePanel);
    }

    private void addDateFields() {
        JPanel datePanel = new JPanel(new FlowLayout(2));
        datePanel.add(this.myDays);
        datePanel.add(this.myMonths);
        datePanel.add(this.myYears);
        this.add(datePanel);
    }

    private void refresh() {
        int days = DAYS_IN_THE_MONTH[this.myMonths.getSelectedIndex()];
        if (days > 0) {
            this.fillDays(days);
        } else {
            this.fillDays(this.daysInTheFebruary());
        }
    }

    private void fillDays(int days) {
        int selectedDayIndex = this.myDays.getSelectedIndex();
        this.myDays.removeAllItems();
        for (int i = 0; i < days; ++i) {
            this.myDays.addItem(String.valueOf(i + 1));
        }
        if (selectedDayIndex < this.myDays.getItemCount()) {
            this.myDays.setSelectedIndex(selectedDayIndex);
        } else {
            this.myDays.setSelectedIndex(this.myDays.getItemCount() - 1);
        }
    }

    private int daysInTheFebruary() {
        int year = Integer.parseInt(this.myYears.getValue().toString());
        if (year % 4 > 0) {
            return 29;
        }
        if (year % 100 > 0) {
            return 29;
        }
        return 28;
    }

    public Date getDate() {
        JSpinner spinner = this.myYears;
        this.myCalendar.set(this.getIntValue(spinner), this.myMonths.getSelectedIndex(), this.myDays.getSelectedIndex() + 1, this.getIntValue(this.myHours), this.getIntValue(this.myMinutes), this.getIntValue(this.mySeconds));
        return this.myCalendar.getTime();
    }

    private int getIntValue(JSpinner spinner) {
        return ((IntegerSpinnerModel)spinner.getModel()).getIntValue();
    }
}

