/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.Function;
import javax.swing.JList;

public class NameFilteringListModel<T>
extends FilteringListModel<T> {
    private final Function<T, String> myNamer;
    private int myFullMatchIndex = -1;
    private int myStartsWithIndex = -1;
    private final SpeedSearch mySpeedSearch;

    public NameFilteringListModel(JList list, final Function<T, String> namer, final Condition<String> filter, SpeedSearch speedSearch) {
        super(list);
        this.mySpeedSearch = speedSearch;
        this.myNamer = namer;
        this.setFilter(namer != null ? new Condition<T>(){

            public boolean value(T t) {
                return filter.value(namer.fun(t));
            }
        } : null);
    }

    @Override
    protected void addToFiltered(T elt) {
        super.addToFiltered(elt);
        if (this.myNamer != null) {
            String filterString = this.mySpeedSearch.getFilter().toUpperCase();
            String candidateString = ((String)this.myNamer.fun(elt)).toUpperCase();
            int index = this.getSize() - 1;
            if (this.myFullMatchIndex == -1 && filterString.equals(candidateString)) {
                this.myFullMatchIndex = index;
            }
            if (this.myStartsWithIndex == -1 && candidateString.startsWith(filterString)) {
                this.myStartsWithIndex = index;
            }
        }
    }

    @Override
    public void refilter() {
        this.myFullMatchIndex = -1;
        this.myStartsWithIndex = -1;
        super.refilter();
    }

    public int getClosestMatchIndex() {
        return this.myFullMatchIndex != -1 ? this.myFullMatchIndex : this.myStartsWithIndex;
    }
}

