/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Icons;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;

public abstract class AbstractFieldPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.AbstractFieldPanel");
    private final JComponent myComponent;
    private Runnable myChangeListener;
    protected ArrayList myButtons = new ArrayList(1);
    protected JLabel myLabel;
    private ActionListener myBrowseButtonActionListener;
    private String myViewerDialogTitle;
    private String myLabelText;
    private ComponentWithBrowseButton.MyDoClickAction myDoClickAction;

    public AbstractFieldPanel(JComponent component) {
        this(component, null, null, null, null);
    }

    public AbstractFieldPanel(JComponent component, String labelText, String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable changeListener) {
        this.myComponent = component;
        this.setChangeListener(changeListener);
        this.setLabelText(labelText);
        this.setBrowseButtonActionListener(browseButtonActionListener);
        this.myViewerDialogTitle = viewerDialogTitle;
    }

    public abstract String getText();

    public abstract void setText(String var1);

    @Override
    public void setEnabled(boolean enabled) {
        this.getComponent().setEnabled(enabled);
        if (this.myLabel != null) {
            this.myLabel.setEnabled(enabled);
        }
        for (int i = 0; i < this.myButtons.size(); ++i) {
            JButton button = (JButton)this.myButtons.get(i);
            button.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getComponent().isEnabled();
    }

    protected ComponentWithBrowseButton.MyDoClickAction getDoClickAction() {
        return this.myDoClickAction;
    }

    public final JComponent getComponent() {
        return this.myComponent;
    }

    public final JLabel getFieldLabel() {
        if (this.myLabel == null) {
            this.myLabel = new JLabel(this.myLabelText);
            this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.myLabel.setLabelFor(this.getComponent());
        }
        return this.myLabel;
    }

    public final Runnable getChangeListener() {
        return this.myChangeListener;
    }

    public final void setChangeListener(Runnable runnable) {
        this.myChangeListener = runnable;
    }

    public JButton[] getButtons() {
        return this.myButtons.toArray(new JButton[this.myButtons.size()]);
    }

    public void createComponent() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        if (this.myLabelText != null) {
            this.myLabel = new JLabel(this.myLabelText);
            this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.myLabel.setLabelFor(this.myComponent);
        }
        this.add((Component)this.myComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.myBrowseButtonActionListener != null) {
            FixedSizeButton browseButton = new FixedSizeButton(this.getComponent());
            this.myDoClickAction = new ComponentWithBrowseButton.MyDoClickAction(browseButton);
            browseButton.setFocusable(false);
            browseButton.addActionListener(this.myBrowseButtonActionListener);
            this.myButtons.add(browseButton);
            this.add((Component)browseButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        }
        if (this.myViewerDialogTitle != null) {
            FixedSizeButton showViewerButton = new FixedSizeButton(this.getComponent());
            if (this.myBrowseButtonActionListener == null) {
                LOG.assertTrue(this.myDoClickAction == null);
                this.myDoClickAction = new ComponentWithBrowseButton.MyDoClickAction(showViewerButton);
            }
            showViewerButton.setFocusable(false);
            showViewerButton.setIcon(Icons.OPEN_EDIT_DIALOG_ICON);
            showViewerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viewer viewer = new Viewer();
                    viewer.setTitle(AbstractFieldPanel.this.myViewerDialogTitle);
                    viewer.show();
                }
            });
            this.myButtons.add(showViewerButton);
            this.add((Component)showViewerButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void setBrowseButtonActionListener(ActionListener browseButtonActionListener) {
        this.myBrowseButtonActionListener = browseButtonActionListener;
    }

    public void setViewerDialogTitle(String viewerDialogTitle) {
        this.myViewerDialogTitle = viewerDialogTitle;
    }

    public void setLabelText(String labelText) {
        this.myLabelText = labelText;
    }

    public void setDisplayedMnemonic(char c) {
        this.getFieldLabel().setDisplayedMnemonic(c);
    }

    public void setDisplayedMnemonicIndex(int i) {
        this.getFieldLabel().setDisplayedMnemonicIndex(i);
    }

    protected class Viewer
    extends DialogWrapper {
        protected JTextArea myTextArea;

        public Viewer() {
            super(AbstractFieldPanel.this.getComponent(), true);
            this.init();
        }

        @Override
        protected Action[] createActions() {
            return new Action[]{this.getOKAction(), this.getCancelAction()};
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myTextArea;
        }

        @Override
        protected void doOKAction() {
            AbstractFieldPanel.this.setText(this.myTextArea.getText());
            super.doOKAction();
        }

        @Override
        protected JComponent createCenterPanel() {
            this.myTextArea = new JTextArea(10, 50);
            this.myTextArea.setText(AbstractFieldPanel.this.getText());
            this.myTextArea.setWrapStyleWord(true);
            this.myTextArea.setLineWrap(true);
            this.myTextArea.getDocument().addDocumentListener(new DocumentAdapter(){

                @Override
                public void textChanged(DocumentEvent event) {
                    if (AbstractFieldPanel.this.myChangeListener != null) {
                        AbstractFieldPanel.this.myChangeListener.run();
                    }
                }
            });
            new AnAction(){

                @Override
                public void actionPerformed(AnActionEvent e) {
                    Viewer.this.doOKAction();
                }
            }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0)), this.myTextArea);
            return new JScrollPane(this.myTextArea);
        }
    }
}

