/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaCodeInsightTestFixtureImpl
extends CodeInsightTestFixtureImpl
implements JavaCodeInsightTestFixture {
    public JavaCodeInsightTestFixtureImpl(IdeaProjectTestFixture projectFixture, TempDirTestFixture tempDirFixture) {
        super(projectFixture, tempDirFixture);
    }

    @Override
    public JavaPsiFacade getJavaFacade() {
        this.assertInitialized();
        return JavaPsiFacade.getInstance(this.getProject());
    }

    @Override
    public PsiClass addClass(@NotNull @NonNls String classText) throws IOException {
        if (classText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl.addClass must not be null");
        }
        this.assertInitialized();
        PsiClass psiClass = this.addClass(this.getTempDirPath(), classText);
        VirtualFile file = psiClass.getContainingFile().getVirtualFile();
        this.allowTreeAccessForFile(file);
        return psiClass;
    }

    private PsiClass addClass(@NonNls String rootPath, @NotNull @NonNls String classText) throws IOException {
        if (classText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl.addClass must not be null");
        }
        PsiClass aClass = ((PsiJavaFile)PsiFileFactory.getInstance(this.getProject()).createFileFromText("a.java", classText)).getClasses()[0];
        String qName = aClass.getQualifiedName();
        assert (qName != null);
        PsiFile psiFile = this.addFileToProject(rootPath, qName.replace('.', '/') + ".java", classText);
        return ((PsiJavaFile)psiFile).getClasses()[0];
    }

    @Override
    @NotNull
    public PsiClass findClass(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl.findClass must not be null");
        }
        PsiClass aClass = this.getJavaFacade().findClass(name, ProjectScope.getProjectScope(this.getProject()));
        JavaCodeInsightTestFixtureImpl.assertNotNull((String)("Class " + name + " not found"), (Object)aClass);
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl.findClass must not return null");
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiPackage findPackage(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl.findPackage must not be null");
        }
        PsiPackage aPackage = this.getJavaFacade().findPackage(name);
        JavaCodeInsightTestFixtureImpl.assertNotNull((String)("Package " + name + " not found"), (Object)aPackage);
        PsiPackage psiPackage = aPackage;
        if (psiPackage == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl.findPackage must not return null");
        }
        return psiPackage;
    }
}

