/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFile;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightVirtualFile
extends DeprecatedVirtualFile {
    private FileType myFileType;
    private CharSequence myContent = "";
    private String myName = "";
    private long myModStamp = LocalTimeCounter.currentTime();
    private boolean myIsWritable = true;
    private boolean myValid = true;
    private Language myLanguage;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NonNls String name) {
        this(name, "");
    }

    public LightVirtualFile(@NonNls String name, CharSequence content) {
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text) {
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(VirtualFile original, CharSequence text, long modificationStamp) {
        this(original.getName(), original.getFileType(), text, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text, long modificationStamp) {
        this(name, fileType, text, LightVirtualFile.charsetFromContent(fileType, text), modificationStamp);
    }

    private static Charset charsetFromContent(FileType fileType, CharSequence text) {
        if (fileType instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(null, null, ((Object)text).toString());
        }
        return null;
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text, Charset charset, long modificationStamp) {
        this.myName = name;
        this.myFileType = fileType;
        this.setContent(text);
        this.myModStamp = modificationStamp;
        this.setCharset(charset);
    }

    public LightVirtualFile(String name, Language language, CharSequence text) {
        this.myName = name;
        this.setContent(text);
        this.myModStamp = LocalTimeCounter.currentTime();
        this.setLanguage(language);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(Language language) {
        this.myLanguage = language;
        this.myFileType = language.getAssociatedFileType();
        if (this.myFileType == null) {
            this.myFileType = FileTypeManager.getInstance().getFileTypeByFileName(this.myName);
        }
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    private void setContent(CharSequence content) {
        this.myContent = content;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MyVirtualFileSystem myVirtualFileSystem = ourFileSystem;
        if (myVirtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile.getFileSystem must not return null");
        }
        return myVirtualFileSystem;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType != null ? this.myFileType : super.getFileType();
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile.getFileType must not return null");
        }
        return fileType;
    }

    @Override
    public String getPath() {
        return "/" + this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile.getName must not return null");
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.contentsToByteArray());
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

            @Override
            public void close() {
                LightVirtualFile.this.myModStamp = newModificationStamp;
                LightVirtualFile.this.setContent(this.toString());
            }
        };
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile.getOutputStream must not return null");
        }
        return byteArrayOutputStream;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = ((Object)this.getContent()).toString();
        byte[] byArray = charset != null ? s.getBytes(charset.name()) : s.getBytes();
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile.contentsToByteArray must not return null");
        }
        return byArray;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public void setContent(Object requestor, CharSequence content, boolean fireEvent) {
        this.setContent(content);
        this.myModStamp = LocalTimeCounter.currentTime();
    }

    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    @Override
    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile.rename must not be null");
        }
        this.myName = newName;
    }

    public CharSequence getContent() {
        return this.myContent;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }

    private static class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem {
        @NonNls
        private static final String PROTOCOL = "mock";

        private MyVirtualFileSystem() {
        }

        @Override
        @NotNull
        public String getProtocol() {
            if (PROTOCOL == null) {
                throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.getProtocol must not return null");
            }
            return PROTOCOL;
        }

        @Override
        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.findFileByPath must not be null");
            }
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.refreshAndFindFileByPath must not be null");
            }
            return null;
        }

        @Override
        public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
            if (vFile == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.deleteFile must not be null");
            }
        }

        @Override
        public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
            if (vFile == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.moveFile must not be null");
            }
            if (newParent == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.moveFile must not be null");
            }
        }

        @Override
        public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
            if (vFile == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.copyFile must not be null");
            }
            if (newParent == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.copyFile must not be null");
            }
            if (copyName == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.copyFile must not be null");
            }
            throw new IOException("Cannot copy files");
        }

        @Override
        public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
            if (vFile == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.renameFile must not be null");
            }
            if (newName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.renameFile must not be null");
            }
        }

        @Override
        public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
            if (vDir == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.createChildFile must not be null");
            }
            if (fileName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.createChildFile must not be null");
            }
            throw new IOException("Cannot create files");
        }

        @Override
        @NotNull
        public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
            if (vDir == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.createChildDirectory must not be null");
            }
            if (dirName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.createChildDirectory must not be null");
            }
            throw new IOException("Cannot create directories");
        }
    }
}

