/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.semantic.SemElement;
import com.intellij.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;

public class SemKey<T extends SemElement> {
    private static AtomicInteger counter = new AtomicInteger(0);
    private final String myDebugName;
    private final SemKey<? super T>[] mySupers;
    private final int myUniqueId;

    private SemKey(String debugName, SemKey<? super T> ... supers) {
        this.myDebugName = debugName;
        this.mySupers = supers;
        this.myUniqueId = counter.getAndIncrement();
    }

    public SemKey<? super T>[] getSupers() {
        return this.mySupers;
    }

    public boolean isKindOf(SemKey<?> another) {
        if (another == this) {
            return true;
        }
        for (SemKey<T> semKey : this.mySupers) {
            if (!semKey.isKindOf(another)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.myDebugName;
    }

    public static <T extends SemElement> SemKey<T> createKey(String debugName, SemKey<? super T> ... supers) {
        return new SemKey<T>(debugName, supers);
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    public <K extends T> SemKey<K> subKey(@NonNls String debugName, SemKey<? super T> ... otherSupers) {
        if (otherSupers.length == 0) {
            return new SemKey<T>(debugName, this);
        }
        return new SemKey<T>(debugName, (SemKey[])ArrayUtil.append((Object[])otherSupers, (Object)this));
    }
}

