/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ReflectionCache;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiElementPattern<T extends PsiElement, Self extends PsiElementPattern<T, Self>>
extends TreeElementPattern<PsiElement, T, Self> {
    protected PsiElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected PsiElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.<init> must not be null");
        }
        super(condition);
    }

    protected PsiElement[] getChildren(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.getChildren must not be null");
        }
        return element.getChildren();
    }

    @Override
    protected PsiElement getParent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.getParent must not be null");
        }
        return element.getContext();
    }

    public Self withElementType(IElementType type) {
        return this.withElementType((ElementPattern<IElementType>)PlatformPatterns.elementType().equalTo(type));
    }

    public Self withElementType(TokenSet type) {
        return this.withElementType(PlatformPatterns.elementType().tokenSet(type));
    }

    public Self afterLeaf(String ... withText) {
        if (withText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.afterLeaf must not be null");
        }
        return this.afterLeaf((ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withText(PlatformPatterns.string().oneOf(withText)));
    }

    public Self afterLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.afterLeaf must not be null");
        }
        return this.afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentOrError(), pattern);
    }

    public Self beforeLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.beforeLeaf must not be null");
        }
        return this.beforeLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentOrError(), pattern);
    }

    public Self whitespace() {
        return this.withElementType(TokenType.WHITE_SPACE);
    }

    public Self whitespaceCommentOrError() {
        return (Self)((PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class)}));
    }

    public Self withFirstNonWhitespaceChild(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.withFirstNonWhitespaceChild must not be null");
        }
        return (Self)((PsiElementPattern)this.withChildren(StandardPatterns.collection(PsiElement.class).filter(StandardPatterns.not(PlatformPatterns.psiElement().whitespace()), StandardPatterns.collection(PsiElement.class).first(pattern))));
    }

    public Self withReference(final Class<? extends PsiReference> referenceClass) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withReference"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$1.accepts must not be null");
                }
                for (PsiReference reference : t.getReferences()) {
                    if (!ReflectionCache.isInstance((Object)reference, (Class)referenceClass)) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    public Self inFile(final @NotNull ElementPattern<? extends PsiFile> filePattern) {
        if (filePattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.inFile must not be null");
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("inFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$2.accepts must not be null");
                }
                return filePattern.accepts(t.getContainingFile(), context);
            }
        }));
    }

    public Self inVirtualFile(final @NotNull ElementPattern<? extends VirtualFile> filePattern) {
        if (filePattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.inVirtualFile must not be null");
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("inVirtualFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$3.accepts must not be null");
                }
                return filePattern.accepts(t.getContainingFile().getViewProvider().getVirtualFile(), context);
            }
        }));
    }

    @Override
    public Self equalTo(@NotNull T o) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.equalTo must not be null");
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("equalTo", (PsiElement)o){
            final /* synthetic */ PsiElement val$o;
            {
                this.val$o = psiElement;
                super(x0);
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$4.accepts must not be null");
                }
                return t.getManager().areElementsEquivalent((PsiElement)t, this.val$o);
            }
        }));
    }

    public Self withElementType(final ElementPattern<IElementType> pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withElementType"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$5.accepts must not be null");
                }
                ASTNode node = t.getNode();
                return node != null && pattern.accepts(node.getElementType());
            }
        }));
    }

    public Self withText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.withText must not be null");
        }
        return this.withText((ElementPattern)StandardPatterns.string().equalTo(text));
    }

    public Self withoutText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.withoutText must not be null");
        }
        return this.withoutText((ElementPattern)StandardPatterns.string().equalTo(text));
    }

    public Self withName(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.withName must not be null");
        }
        return this.withName((ElementPattern<String>)StandardPatterns.string().equalTo(name));
    }

    public Self withName(@NotNull ElementPattern<String> name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.withName must not be null");
        }
        return (Self)((PsiElementPattern)this.with(new PsiNamePatternCondition("withName", name)));
    }

    public Self afterLeafSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        if (skip == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.afterLeafSkipping must not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.afterLeafSkipping must not be null");
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("afterLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$6.accepts must not be null");
                }
                Object element = t;
                while (true) {
                    if (element != null && element.getPrevSibling() == null) {
                        element = element.getParent();
                        continue;
                    }
                    if (element != null) {
                        for (element = element.getPrevSibling(); element != null && element.getLastChild() != null; element = element.getLastChild()) {
                        }
                        if (element != null && element.getTextLength() == 0) continue;
                    }
                    if (!skip.getCondition().accepts(element, context)) break;
                }
                return pattern.getCondition().accepts(element, context);
            }
        }));
    }

    public Self beforeLeafSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        if (skip == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.beforeLeafSkipping must not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.beforeLeafSkipping must not be null");
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("baforeLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$7.accepts must not be null");
                }
                Object element = t;
                while (true) {
                    if (element != null && element.getNextSibling() == null) {
                        element = element.getParent();
                        continue;
                    }
                    if (element != null) {
                        for (element = element.getNextSibling(); element != null && element.getFirstChild() != null; element = element.getFirstChild()) {
                        }
                        if (element != null && element.getTextLength() == 0) continue;
                    }
                    if (!skip.getCondition().accepts(element, context)) break;
                }
                return pattern.getCondition().accepts(element, context);
            }
        }));
    }

    public Self withText(@NotNull ElementPattern text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.withText must not be null");
        }
        return (Self)((PsiElementPattern)this.with(this._withText(text)));
    }

    private PatternCondition<T> _withText(final ElementPattern pattern) {
        return new PatternCondition<T>("_withText"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$8.accepts must not be null");
                }
                return pattern.getCondition().accepts(t.getText(), context);
            }
        };
    }

    public Self withoutText(@NotNull ElementPattern text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.withoutText must not be null");
        }
        return (Self)((PsiElementPattern)this.without(this._withText(text)));
    }

    public Self withLanguage(final @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern.withLanguage must not be null");
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withLanguage"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$9.accepts must not be null");
                }
                return ((Object)((Object)t.getLanguage())).equals((Object)language);
            }
        }));
    }

    public Self withMetaData(final ElementPattern<? extends PsiMetaData> metaDataPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withMetaData"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$10.accepts must not be null");
                }
                return t instanceof PsiMetaOwner && metaDataPattern.accepts(((PsiMetaOwner)t).getMetaData(), context);
            }
        }));
    }

    public Self referencing(final ElementPattern<? extends PsiElement> targetPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("referencing"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiReference[] references;
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$11.accepts must not be null");
                }
                for (PsiReference reference : references = t.getReferences()) {
                    if (targetPattern.accepts(reference.resolve(), context)) {
                        return true;
                    }
                    if (!(reference instanceof PsiPolyVariantReference)) continue;
                    for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(true)) {
                        if (!targetPattern.accepts(result.getElement(), context)) continue;
                        return true;
                    }
                }
                return false;
            }
        }));
    }

    public Self compiled() {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("compiled"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$12.accepts must not be null");
                }
                return t instanceof PsiCompiledElement;
            }
        }));
    }

    public static class Capture<T extends PsiElement>
    extends PsiElementPattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        protected Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiElementPattern$Capture.<init> must not be null");
            }
            super(condition);
        }
    }
}

