/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShowMessageHistoryAction
extends AnAction
implements DumbAware {
    public ShowMessageHistoryAction() {
        this.setEnabledInModalContext(true);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        CheckinProjectPanel panel = (CheckinProjectPanel)CheckinProjectPanel.PANEL_KEY.getData(e.getDataContext());
        if (panel == null) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setVisible(true);
            ArrayList<String> recentMessages = VcsConfiguration.getInstance(panel.getProject()).getRecentMessages();
            e.getPresentation().setEnabled(!recentMessages.isEmpty());
        }
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project;
        VcsConfiguration configuration;
        CheckinProjectPanel panel = (CheckinProjectPanel)CheckinProjectPanel.PANEL_KEY.getData(e.getDataContext());
        if (panel != null && !(configuration = VcsConfiguration.getInstance(project = panel.getProject())).getRecentMessages().isEmpty()) {
            int selectedIndex;
            ContentChooser<String> contentChooser = new ContentChooser<String>(project, VcsBundle.message("dialog.title.choose.commit.message.from.history", new Object[0]), false){

                @Override
                protected void removeContentAt(String content) {
                    configuration.removeMessage(content);
                }

                @Override
                protected String getStringRepresentationFor(String content) {
                    return content;
                }

                @Override
                protected List<String> getContents() {
                    ArrayList<String> recentMessages = configuration.getRecentMessages();
                    Collections.reverse(recentMessages);
                    return recentMessages;
                }
            };
            contentChooser.show();
            if (contentChooser.isOK() && (selectedIndex = contentChooser.getSelectedIndex()) >= 0) {
                panel.setCommitMessage((String)contentChooser.getAllContents().get(selectedIndex));
            }
        }
    }
}

